export interface Actions<T> {
    set: (list: T[]) => void;
    clear: () => void;
    updateAt: (index: number, item: T) => void;
    remove: (index: number) => void;
    push: (...items: T[]) => void;
    filter: (fn: (value: T) => boolean) => void;
    sort: (fn?: (a: T, b: T) => number) => void;
    reset: () => void;
}
declare const useList: <T>(initialList?: T[]) => [T[], Actions<T>];
export default useList;
