import { useRef } from 'react';
function strictEquals(prev, next) {
    return prev === next;
}
export default function usePreviousDistinct(value, compare) {
    if (compare === void 0) { compare = strictEquals; }
    var prevRef = useRef();
    var curRef = useRef();
    if (!compare(curRef.current, value)) {
        prevRef.current = curRef.current;
        curRef.current = value;
    }
    return prevRef.current;
}
