import { useState, useCallback } from 'react';
import useUpdateEffect from './useUpdateEffect';
export default function useStateList(stateSet) {
    if (stateSet === void 0) { stateSet = []; }
    var _a = useState(0), currentIndex = _a[0], setCurrentIndex = _a[1];
    // In case we receive a different state set, check if the current index still exists and
    // reset it to the last if it don't.
    useUpdateEffect(function () {
        if (!stateSet[currentIndex]) {
            setCurrentIndex(stateSet.length - 1);
        }
    }, [stateSet]);
    var next = useCallback(function () {
        var nextStateIndex = stateSet.length === currentIndex + 1 ? 0 : currentIndex + 1;
        setCurrentIndex(nextStateIndex);
    }, [stateSet, currentIndex]);
    var prev = useCallback(function () {
        var prevStateIndex = currentIndex === 0 ? stateSet.length - 1 : currentIndex - 1;
        setCurrentIndex(prevStateIndex);
    }, [stateSet, currentIndex]);
    return {
        state: stateSet[currentIndex],
        next: next,
        prev: prev,
    };
}
