import { Dispatch, SetStateAction } from 'react';
export declare type ValidityState = [boolean | undefined, ...any[]];
export declare type DispatchValidity<V extends ValidityState> = Dispatch<SetStateAction<V>>;
export declare type Validator<V extends ValidityState, S = any> = {
    (state?: S): V;
    (state?: S, dispatch?: DispatchValidity<V>): void;
} | Function;
export declare type UseValidatorReturn<V extends ValidityState> = [V, () => void];
export default function useStateValidator<V extends ValidityState, S = any>(state: S, validator: Validator<V, S>, initialValidity?: V): UseValidatorReturn<V>;
