import { useCallback, useEffect, useRef, useState } from 'react';
export default function useStateValidator(state, validator, initialValidity) {
    if (initialValidity === void 0) { initialValidity = [undefined]; }
    var validatorFn = useRef(validator);
    var _a = useState(initialValidity), validity = _a[0], setValidity = _a[1];
    var validate = useCallback(function () {
        if (validatorFn.current.length === 2) {
            validatorFn.current(state, setValidity);
        }
        else {
            setValidity(validatorFn.current(state));
        }
    }, [state]);
    useEffect(function () {
        validate();
    }, [state]);
    return [validity, validate];
}
