import { useEffect, useRef } from 'react';
var useUpdateEffect = function (effect, deps) {
    var isInitialMount = useRef(true);
    useEffect(function () {
        if (isInitialMount.current) {
            isInitialMount.current = false;
        }
        else {
            return effect();
        }
    }, deps);
};
export default useUpdateEffect;
