import * as tslib_1 from "tslib";
import useList from './useList';
var useUpsert = function (comparisonFunction, initialList) {
    if (initialList === void 0) { initialList = []; }
    var _a = useList(initialList), items = _a[0], actions = _a[1];
    var upsert = function (upsertedItem) {
        var itemWasFound = false;
        for (var i = 0; i < items.length; i++) {
            var existingItem = items[i];
            var shouldUpdate = comparisonFunction(existingItem, upsertedItem);
            if (shouldUpdate) {
                actions.updateAt(i, upsertedItem);
                itemWasFound = true;
                break;
            }
        }
        if (!itemWasFound) {
            actions.push(upsertedItem);
        }
    };
    return [
        items,
        tslib_1.__assign({}, actions, { upsert: upsert }),
    ];
};
export default useUpsert;
