"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useList = function (initialList) {
    if (initialList === void 0) { initialList = []; }
    var _a = react_1.useState(initialList), list = _a[0], set = _a[1];
    var utils = react_1.useMemo(function () { return ({
        set: set,
        clear: function () { return set([]); },
        updateAt: function (index, entry) {
            return set(function (currentList) { return currentList.slice(0, index).concat([entry], currentList.slice(index + 1)); });
        },
        remove: function (index) { return set(function (currentList) { return currentList.slice(0, index).concat(currentList.slice(index + 1)); }); },
        push: function () {
            var entry = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                entry[_i] = arguments[_i];
            }
            return set(function (currentList) { return currentList.concat(entry); });
        },
        filter: function (fn) { return set(function (currentList) { return currentList.filter(fn); }); },
        sort: function (fn) { return set(function (currentList) { return currentList.slice().sort(fn); }); },
        reset: function () { return set(initialList.slice()); },
    }); }, [set]);
    return [list, utils];
};
exports.default = useList;
