import { DispatchValidity, UseValidatorReturn, ValidityState } from './useStateValidator';
export declare type MultiStateValidatorStates = any[] | {
    [p: string]: any;
} | {
    [p: number]: any;
};
export interface MultiStateValidator<V extends ValidityState = ValidityState, S extends MultiStateValidatorStates = MultiStateValidatorStates> {
    (states: S): V;
    (states: S, done: DispatchValidity<V>): void;
}
export declare function useMultiStateValidator<V extends ValidityState = ValidityState, S extends MultiStateValidatorStates = MultiStateValidatorStates>(states: S, validator: MultiStateValidator<V, S>, initialValidity?: V): UseValidatorReturn<V>;
