"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
function useMultiStateValidator(states, validator, initialValidity) {
    if (initialValidity === void 0) { initialValidity = [undefined]; }
    if (typeof states !== 'object') {
        throw new Error('states expected to be an object or array, got ' + typeof states);
    }
    var validatorFn = react_1.useRef(validator);
    var _a = react_1.useState(initialValidity), validity = _a[0], setValidity = _a[1];
    var deps = Array.isArray(states) ? states : Object.values(states);
    var validate = react_1.useCallback(function () {
        if (validatorFn.current.length === 2) {
            validatorFn.current(states, setValidity);
        }
        else {
            setValidity(validatorFn.current(states));
        }
    }, deps);
    react_1.useEffect(function () {
        validate();
    }, deps);
    return [validity, validate];
}
exports.useMultiStateValidator = useMultiStateValidator;
