"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = require("react");
var useUpdateEffect_1 = tslib_1.__importDefault(require("./useUpdateEffect"));
function useStateList(stateSet) {
    if (stateSet === void 0) { stateSet = []; }
    var _a = react_1.useState(0), currentIndex = _a[0], setCurrentIndex = _a[1];
    // In case we receive a different state set, check if the current index still exists and
    // reset it to the last if it don't.
    useUpdateEffect_1.default(function () {
        if (!stateSet[currentIndex]) {
            setCurrentIndex(stateSet.length - 1);
        }
    }, [stateSet]);
    var next = react_1.useCallback(function () {
        var nextStateIndex = stateSet.length === currentIndex + 1 ? 0 : currentIndex + 1;
        setCurrentIndex(nextStateIndex);
    }, [stateSet, currentIndex]);
    var prev = react_1.useCallback(function () {
        var prevStateIndex = currentIndex === 0 ? stateSet.length - 1 : currentIndex - 1;
        setCurrentIndex(prevStateIndex);
    }, [stateSet, currentIndex]);
    return {
        state: stateSet[currentIndex],
        next: next,
        prev: prev,
    };
}
exports.default = useStateList;
