"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useUpdateEffect = function (effect, deps) {
    var isInitialMount = react_1.useRef(true);
    react_1.useEffect(function () {
        if (isInitialMount.current) {
            isInitialMount.current = false;
        }
        else {
            return effect();
        }
    }, deps);
};
exports.default = useUpdateEffect;
