"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var useList_1 = tslib_1.__importDefault(require("./useList"));
var useUpsert = function (comparisonFunction, initialList) {
    if (initialList === void 0) { initialList = []; }
    var _a = useList_1.default(initialList), items = _a[0], actions = _a[1];
    var upsert = function (upsertedItem) {
        var itemWasFound = false;
        for (var i = 0; i < items.length; i++) {
            var existingItem = items[i];
            var shouldUpdate = comparisonFunction(existingItem, upsertedItem);
            if (shouldUpdate) {
                actions.updateAt(i, upsertedItem);
                itemWasFound = true;
                break;
            }
        }
        if (!itemWasFound) {
            actions.push(upsertedItem);
        }
    };
    return [
        items,
        tslib_1.__assign({}, actions, { upsert: upsert }),
    ];
};
exports.default = useUpsert;
