import { useState, useMemo } from 'react';
import useIsomorphicLayoutEffect from './useIsomorphicLayoutEffect';
import { isClient } from './util';
var defaultState = {
    x: -1,
    y: -1,
    width: -1,
    height: -1,
    top: -1,
    left: -1,
    bottom: -1,
    right: -1,
};
var useMeasure = function () {
    var _a = useState(null), element = _a[0], ref = _a[1];
    var _b = useState(defaultState), rect = _b[0], setRect = _b[1];
    var observer = useMemo(function () {
        return new window.ResizeObserver(function (entries) {
            if (entries[0]) {
                var _a = entries[0].contentRect, x = _a.x, y = _a.y, width = _a.width, height = _a.height, top_1 = _a.top, left = _a.left, bottom = _a.bottom, right = _a.right;
                setRect({ x: x, y: y, width: width, height: height, top: top_1, left: left, bottom: bottom, right: right });
            }
        });
    }, []);
    useIsomorphicLayoutEffect(function () {
        if (!element)
            return;
        observer.observe(element);
        return function () {
            observer.disconnect();
        };
    }, [element]);
    return [ref, rect];
};
var useMeasureMock = function () { return [function () { }, defaultState]; };
export default (isClient && !!window.ResizeObserver) ? useMeasure : useMeasureMock;
