'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _d3Interpolate = require('d3-interpolate');

var _reactMotion = require('react-motion');

var _pureRenderComponent = require('./pure-render-component');

var _pureRenderComponent2 = _interopRequireDefault(_pureRenderComponent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  animatedProps: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.string).isRequired,
  onStart: _react2.default.PropTypes.func,
  onEnd: _react2.default.PropTypes.func,
  stiffness: _react2.default.PropTypes.number,
  damping: _react2.default.PropTypes.number,
  precision: _react2.default.PropTypes.number
};

var Animation = function (_PureRenderComponent) {
  _inherits(Animation, _PureRenderComponent);

  function Animation(props) {
    _classCallCheck(this, Animation);

    var _this = _possibleConstructorReturn(this, (Animation.__proto__ || Object.getPrototypeOf(Animation)).call(this, props));

    _this._updateInterpolator(props);
    _this._renderChildren = _this._renderChildren.bind(_this);
    _this._motionEndHandler = _this._motionEndHandler.bind(_this);
    return _this;
  }

  _createClass(Animation, [{
    key: 'componentWillUpdate',
    value: function componentWillUpdate(props) {
      this._updateInterpolator(this.props, props);
      if (props.onStart) {
        props.onStart();
      }
    }

    /**
     * Update the interpolator function and assign it to this._interpolator.
     * @param {Object} oldProps Old props.
     * @param {Object} newProps New props.
     * @private
     */

  }, {
    key: '_updateInterpolator',
    value: function _updateInterpolator(oldProps, newProps) {
      this._interpolator = (0, _d3Interpolate.interpolate)(this._extractAnimatedPropValues(oldProps), newProps ? this._extractAnimatedPropValues(newProps) : null);
    }

    /**
     * Extract the animated props from the entire props object.
     * @param {Object} props Props.
     * @returns {Object} Object of animated props.
     * @private
     */

  }, {
    key: '_extractAnimatedPropValues',
    value: function _extractAnimatedPropValues(props) {
      var animatedProps = props.animatedProps,
          otherProps = _objectWithoutProperties(props, ['animatedProps']);

      return animatedProps.reduce(function (result, animatedPropName) {
        if (otherProps.hasOwnProperty(animatedPropName)) {
          result[animatedPropName] = otherProps[animatedPropName];
        }
        return result;
      }, {});
    }

    /**
     * Render the child into the parent.
     * @param {Number} i Number generated by the spring.
     * @returns {React.Component} Rendered react element.
     * @private
     */

  }, {
    key: '_renderChildren',
    value: function _renderChildren(_ref) {
      var i = _ref.i;
      var children = this.props.children;

      var interpolator = this._interpolator;
      var child = _react2.default.Children.only(children);
      var interpolatedProps = interpolator ? interpolator(i) : interpolator;

      return _react2.default.cloneElement(child, _extends({}, child.props, interpolatedProps, {
        // enforce re-rendering
        _animation: Math.random()
      }));
    }
  }, {
    key: '_motionEndHandler',
    value: function _motionEndHandler() {
      if (this.props.onEnd) {
        this.props.onEnd();
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var defaultStyle = { i: 0 };
      var style = { i: (0, _reactMotion.spring)(1) };
      // In order to make Motion re-run animations each time, the random key is
      // always passed.
      // TODO: find a better solution for the spring.
      var key = Math.random();
      return _react2.default.createElement(
        _reactMotion.Motion,
        _extends({ defaultStyle: defaultStyle, style: style, key: key }, { onRest: this._motionEndHandler }),
        this._renderChildren
      );
    }
  }]);

  return Animation;
}(_pureRenderComponent2.default);

Animation.propTypes = propTypes;
Animation.displayName = 'Animation';

exports.default = Animation;