'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _discreteColorLegendItem = require('./discrete-color-legend-item');

var _discreteColorLegendItem2 = _interopRequireDefault(_discreteColorLegendItem);

var _theme = require('../theme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var propTypes = {
  items: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.oneOfType([_react2.default.PropTypes.shape({
    title: _react2.default.PropTypes.string.isRequired,
    color: _react2.default.PropTypes.string,
    disabled: _react2.default.PropTypes.bool
  }), _react2.default.PropTypes.string.isRequired])).isRequired,
  onItemClick: _react2.default.PropTypes.func,
  height: _react2.default.PropTypes.number,
  width: _react2.default.PropTypes.number,
  orientation: _react2.default.PropTypes.oneOf(['vertical', 'horizontal'])
};

var defaultProps = {
  colors: _theme.DISCRETE_COLOR_RANGE,
  orientation: 'vertical'
};

function fillItemsWithDefaults(items) {
  return items.map(function (item, i) {
    return {
      title: item.title ? item.title : item,
      color: item.color ? item.color : _theme.DISCRETE_COLOR_RANGE[i % _theme.DISCRETE_COLOR_RANGE.length],
      disabled: Boolean(item.disabled)
    };
  });
}

function DiscreteColorLegend(_ref) {
  var initialItems = _ref.items,
      width = _ref.width,
      height = _ref.height,
      onItemClick = _ref.onItemClick,
      orientation = _ref.orientation;

  var updatedItems = fillItemsWithDefaults(initialItems);
  return _react2.default.createElement(
    'div',
    {
      className: 'rv-discrete-color-legend ' + orientation,
      style: { width: width, height: height } },
    updatedItems.map(function (item, i) {
      return _react2.default.createElement(_discreteColorLegendItem2.default, _extends({}, item, {
        orientation: orientation,
        key: i,
        onClick: onItemClick ? function () {
          return onItemClick(initialItems[i], i);
        } : null }));
    })
  );
}

DiscreteColorLegend.displayName = 'DiscreteColorLegendItem';
DiscreteColorLegend.propTypes = propTypes;
DiscreteColorLegend.defaultProps = defaultProps;

exports.default = DiscreteColorLegend;