'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _discreteColorLegend = require('./discrete-color-legend');

var _discreteColorLegend2 = _interopRequireDefault(_discreteColorLegend);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var propTypes = _extends({}, _discreteColorLegend2.default.propTypes, {
  searchText: _react2.default.PropTypes.string,
  onSearchChange: _react2.default.PropTypes.func,
  searchPlaceholder: _react2.default.PropTypes.string,
  searchFn: _react2.default.PropTypes.func
});

var defaultProps = {
  searchText: '',
  searchFn: function searchFn(items, s) {
    return items.filter(function (item) {
      return String(item.title || item).toLowerCase().indexOf(s) !== -1;
    });
  }
};

function SearchableDiscreteColorLegend(props) {
  var items = props.items,
      onItemClick = props.onItemClick,
      searchFn = props.searchFn,
      onSearchChange = props.onSearchChange,
      searchText = props.searchText,
      searchPlaceholder = props.searchPlaceholder,
      width = props.width,
      height = props.height;

  var onChange = onSearchChange ? function (_ref) {
    var value = _ref.target.value;
    return onSearchChange(value);
  } : null;
  var filteredItems = searchFn(items, searchText);
  return _react2.default.createElement(
    'div',
    { className: 'rv-search-wrapper', style: { width: width, height: height } },
    _react2.default.createElement(
      'form',
      { className: 'rv-search-wrapper__form' },
      _react2.default.createElement('input', {
        type: 'search',
        placeholder: searchPlaceholder,
        className: 'rv-search-wrapper__form__input',
        value: searchText,
        onChange: onChange })
    ),
    _react2.default.createElement(
      'div',
      { className: 'rv-search-wrapper__contents' },
      _react2.default.createElement(_discreteColorLegend2.default, {
        items: filteredItems,
        onItemClick: onItemClick })
    )
  );
}

SearchableDiscreteColorLegend.propTypes = propTypes;
SearchableDiscreteColorLegend.defaultProps = defaultProps;
SearchableDiscreteColorLegend.displayName = 'SearchableDiscreteColorLegend';

exports.default = SearchableDiscreteColorLegend;