'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _axisUtils = require('../../utils/axis-utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var LEFT = _axisUtils.ORIENTATION.LEFT,
    RIGHT = _axisUtils.ORIENTATION.RIGHT,
    TOP = _axisUtils.ORIENTATION.TOP,
    BOTTOM = _axisUtils.ORIENTATION.BOTTOM;


var propTypes = {
  width: _react2.default.PropTypes.number.isRequired,
  height: _react2.default.PropTypes.number.isRequired,
  orientation: _react2.default.PropTypes.oneOf([LEFT, RIGHT, TOP, BOTTOM]).isRequired,
  title: _react2.default.PropTypes.string.isRequired
};

function AxisTitle(_ref) {
  var orientation = _ref.orientation,
      width = _ref.width,
      height = _ref.height,
      title = _ref.title;

  var x = orientation === LEFT ? width : 0;
  var y = orientation === TOP ? height : 0;
  var style = void 0;
  if (orientation === LEFT) {
    style = {
      transform: 'translate(1em, 0) rotate(-90deg)',
      textAnchor: 'end'
    };
  } else if (orientation === RIGHT) {
    style = {
      transform: 'translate(-0.5em, ' + height + 'px) rotate(-90deg)',
      textAnchor: 'start'
    };
  } else if (orientation === BOTTOM) {
    style = {
      transform: 'translate(' + width + 'px, -6px)',
      textAnchor: 'end'
    };
  } else {
    style = {
      transform: 'translate(0px, 1em)'
    };
  }
  return _react2.default.createElement(
    'g',
    { transform: 'translate(' + x + ', ' + y + ')', className: 'rv-xy-plot__axis__title' },
    _react2.default.createElement(
      'g',
      { style: style },
      _react2.default.createElement(
        'text',
        null,
        title
      )
    )
  );
}

AxisTitle.displayName = 'AxisTitle';
AxisTitle.propTypes = propTypes;

exports.default = AxisTitle;