'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _animation = require('../../animation');

var _animation2 = _interopRequireDefault(_animation);

var _pureRenderComponent = require('../../pure-render-component');

var _pureRenderComponent2 = _interopRequireDefault(_pureRenderComponent);

var _axisUtils = require('../../utils/axis-utils');

var _axisLine = require('./axis-line');

var _axisLine2 = _interopRequireDefault(_axisLine);

var _axisTicks = require('./axis-ticks');

var _axisTicks2 = _interopRequireDefault(_axisTicks);

var _axisTitle = require('./axis-title');

var _axisTitle2 = _interopRequireDefault(_axisTitle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var animatedProps = ['xRange', 'yRange', 'xDomain', 'yDomain', 'width', 'height', 'marginLeft', 'marginTop', 'marginRight', 'marginBottom', 'tickSize', 'tickTotal', 'tickSizeInner', 'tickSizeOuter'];

var LEFT = _axisUtils.ORIENTATION.LEFT,
    RIGHT = _axisUtils.ORIENTATION.RIGHT,
    TOP = _axisUtils.ORIENTATION.TOP,
    BOTTOM = _axisUtils.ORIENTATION.BOTTOM;


var propTypes = {
  orientation: _react2.default.PropTypes.oneOf([LEFT, RIGHT, TOP, BOTTOM]),
  attr: _react2.default.PropTypes.string.isRequired,
  width: _react2.default.PropTypes.number,
  height: _react2.default.PropTypes.number,
  top: _react2.default.PropTypes.number,
  left: _react2.default.PropTypes.number,
  title: _react2.default.PropTypes.string,

  className: _react2.default.PropTypes.string,
  tickLabelAngle: _react2.default.PropTypes.number,
  tickSize: _react2.default.PropTypes.number,
  tickSizeInner: _react2.default.PropTypes.number,
  tickSizeOuter: _react2.default.PropTypes.number,
  tickPadding: _react2.default.PropTypes.number,
  tickValues: _react2.default.PropTypes.array,
  tickFormat: _react2.default.PropTypes.func,
  tickTotal: _react2.default.PropTypes.number,

  // Not expected to be used by the users.
  // TODO: Add underscore to these properties later.
  marginTop: _react2.default.PropTypes.number,
  marginBottom: _react2.default.PropTypes.number,
  marginLeft: _react2.default.PropTypes.number,
  marginRight: _react2.default.PropTypes.number,
  innerWidth: _react2.default.PropTypes.number,
  innerHeight: _react2.default.PropTypes.number
};

var defaultProps = {
  tickSize: 6,
  tickPadding: 8,
  orientation: BOTTOM
};

var predefinedClassName = 'rv-xy-plot__axis';
var VERTICAL_CLASS_NAME = 'rv-xy-plot__axis--vertical';
var HORIZONTAL_CLASS_NAME = 'rv-xy-plot__axis--horizontal';

var Axis = function (_PureRenderComponent) {
  _inherits(Axis, _PureRenderComponent);

  function Axis() {
    _classCallCheck(this, Axis);

    return _possibleConstructorReturn(this, (Axis.__proto__ || Object.getPrototypeOf(Axis)).apply(this, arguments));
  }

  _createClass(Axis, [{
    key: '_getDefaultAxisProps',


    /**
     * Define the default values depending on the data passed from the outside.
     * @returns {*} Object of default properties.
     * @private
     */
    value: function _getDefaultAxisProps() {
      var _props = this.props,
          innerWidth = _props.innerWidth,
          innerHeight = _props.innerHeight,
          marginTop = _props.marginTop,
          marginBottom = _props.marginBottom,
          marginLeft = _props.marginLeft,
          marginRight = _props.marginRight,
          orientation = _props.orientation;

      if (orientation === BOTTOM) {
        return {
          tickTotal: (0, _axisUtils.getTicksTotalFromSize)(innerWidth),
          top: innerHeight + marginTop,
          left: marginLeft,
          width: innerWidth,
          height: marginBottom
        };
      } else if (orientation === TOP) {
        return {
          tickTotal: (0, _axisUtils.getTicksTotalFromSize)(innerWidth),
          top: 0,
          left: marginLeft,
          width: innerWidth,
          height: marginTop
        };
      } else if (orientation === LEFT) {
        return {
          tickTotal: (0, _axisUtils.getTicksTotalFromSize)(innerHeight),
          top: marginTop,
          left: 0,
          width: marginLeft,
          height: innerHeight
        };
      }
      return {
        tickTotal: (0, _axisUtils.getTicksTotalFromSize)(innerHeight),
        top: marginTop,
        left: marginLeft + innerWidth,
        width: marginRight,
        height: innerHeight
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var animation = this.props.animation;


      if (animation) {
        return _react2.default.createElement(
          _animation2.default,
          _extends({}, this.props, { animatedProps: animatedProps }),
          _react2.default.createElement(Axis, _extends({}, this.props, { animation: null }))
        );
      }

      var props = _extends({}, this._getDefaultAxisProps(), this.props);

      var className = props.className,
          height = props.height,
          left = props.left,
          orientation = props.orientation,
          title = props.title,
          top = props.top,
          width = props.width;

      var isVertical = [LEFT, RIGHT].indexOf(orientation) > -1;
      var axisClassName = isVertical ? VERTICAL_CLASS_NAME : HORIZONTAL_CLASS_NAME;
      return _react2.default.createElement(
        'g',
        {
          transform: 'translate(' + left + ',' + top + ')',
          className: predefinedClassName + ' ' + axisClassName + ' ' + className },
        _react2.default.createElement(_axisLine2.default, {
          height: height,
          width: width,
          orientation: orientation }),
        _react2.default.createElement(_axisTicks2.default, props),
        title ? _react2.default.createElement(_axisTitle2.default, {
          title: title,
          height: height,
          width: width,
          orientation: orientation }) : null
      );
    }
  }]);

  return Axis;
}(_pureRenderComponent2.default);

Axis.displayName = 'Axis';
Axis.propTypes = propTypes;
Axis.defaultProps = defaultProps;
Axis.requiresSVG = true;

exports.default = Axis;