'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _pureRenderComponent = require('../../pure-render-component');

var _pureRenderComponent2 = _interopRequireDefault(_pureRenderComponent);

var _scalesUtils = require('../../utils/scales-utils');

var _animationUtils = require('../../utils/animation-utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = _extends({}, (0, _scalesUtils.getScalePropTypesByAttribute)('x'), (0, _scalesUtils.getScalePropTypesByAttribute)('y'), (0, _scalesUtils.getScalePropTypesByAttribute)('size'), (0, _scalesUtils.getScalePropTypesByAttribute)('opacity'), (0, _scalesUtils.getScalePropTypesByAttribute)('color'), {
  width: _react2.default.PropTypes.number,
  height: _react2.default.PropTypes.number,
  data: _react2.default.PropTypes.array,
  onValueMouseOver: _react2.default.PropTypes.func,
  onValueMouseOut: _react2.default.PropTypes.func,
  onValueClick: _react2.default.PropTypes.func,
  onSeriesMouseOver: _react2.default.PropTypes.func,
  onSeriesMouseOut: _react2.default.PropTypes.func,
  onSeriesClick: _react2.default.PropTypes.func,
  onNearestX: _react2.default.PropTypes.func,
  animation: _animationUtils.AnimationPropType
});

var defaultProps = {
  className: ''
};

var AbstractSeries = function (_PureRenderComponent) {
  _inherits(AbstractSeries, _PureRenderComponent);

  function AbstractSeries(props) {
    _classCallCheck(this, AbstractSeries);

    var _this = _possibleConstructorReturn(this, (AbstractSeries.__proto__ || Object.getPrototypeOf(AbstractSeries)).call(this, props));

    _this._seriesMouseOverHandler = _this._seriesMouseOverHandler.bind(_this);
    _this._valueMouseOverHandler = _this._valueMouseOverHandler.bind(_this);
    _this._seriesMouseOutHandler = _this._seriesMouseOutHandler.bind(_this);
    _this._valueMouseOutHandler = _this._valueMouseOutHandler.bind(_this);
    _this._seriesClickHandler = _this._seriesClickHandler.bind(_this);
    _this._valueClickHandler = _this._valueClickHandler.bind(_this);
    return _this;
  }

  /**
   * Mouse over handler for the specific series' value.
   * @param {Object} d Value object
   * @param {Object} event Event.
   * @protected
   */


  _createClass(AbstractSeries, [{
    key: '_valueMouseOverHandler',
    value: function _valueMouseOverHandler(d, event) {
      var _props = this.props,
          onValueMouseOver = _props.onValueMouseOver,
          onSeriesMouseOver = _props.onSeriesMouseOver;

      if (onValueMouseOver) {
        onValueMouseOver(d, { event: event });
      }
      if (onSeriesMouseOver) {
        onSeriesMouseOver({ event: event });
      }
    }

    /**
     * Mouse over handler for the entire series.
     * @param {Object} event Event.
     * @protected
     */

  }, {
    key: '_seriesMouseOverHandler',
    value: function _seriesMouseOverHandler(event) {
      var onSeriesMouseOver = this.props.onSeriesMouseOver;

      if (onSeriesMouseOver) {
        onSeriesMouseOver({ event: event });
      }
    }

    /**
     * Mouse out handler for the specific series' value.
     * @param {Object} d Value object
     * @param {Object} event Event.
     * @protected
     */

  }, {
    key: '_valueMouseOutHandler',
    value: function _valueMouseOutHandler(d, event) {
      var _props2 = this.props,
          onValueMouseOut = _props2.onValueMouseOut,
          onSeriesMouseOut = _props2.onSeriesMouseOut;

      if (onValueMouseOut) {
        onValueMouseOut(d, { event: event });
      }
      if (onSeriesMouseOut) {
        onSeriesMouseOut({ event: event });
      }
    }

    /**
     * Mouse out handler for the entire series.
     * @param {Object} event Event.
     * @protected
     */

  }, {
    key: '_seriesMouseOutHandler',
    value: function _seriesMouseOutHandler(event) {
      var onSeriesMouseOut = this.props.onSeriesMouseOut;

      if (onSeriesMouseOut) {
        onSeriesMouseOut({ event: event });
      }
    }

    /**
     * Click handler for the specific series' value.
     * @param {Object} d Value object
     * @param {Object} event Event.
     * @protected
     */

  }, {
    key: '_valueClickHandler',
    value: function _valueClickHandler(d, event) {
      var _props3 = this.props,
          onValueClick = _props3.onValueClick,
          onSeriesClick = _props3.onSeriesClick;

      if (onValueClick) {
        onValueClick(d, { event: event });
      }
      if (onSeriesClick) {
        onSeriesClick({ event: event });
      }
    }

    /**
     * Click handler for the entire series.
     * @param {Object} event Event.
     * @protected
     */

  }, {
    key: '_seriesClickHandler',
    value: function _seriesClickHandler(event) {
      var onSeriesClick = this.props.onSeriesClick;

      if (onSeriesClick) {
        onSeriesClick({ event: event });
      }
    }

    /**
     * Tells the rest of the world that it requires SVG to work.
     * @returns {boolean} Result.
     */

  }, {
    key: '_getAttributeFunctor',


    /**
     * Get attribute functor.
     * @param {string} attr Attribute name
     * @returns {*} Functor.
     * @protected
     */
    value: function _getAttributeFunctor(attr) {
      return (0, _scalesUtils.getAttributeFunctor)(this.props, attr);
    }

    /**
     * Get the attr0 functor.
     * @param {string} attr Attribute name.
     * @returns {*} Functor.
     * @private
     */

  }, {
    key: '_getAttr0Functor',
    value: function _getAttr0Functor(attr) {
      return (0, _scalesUtils.getAttr0Functor)(this.props, attr);
    }

    /**
     * Get the attribute value if it is available.
     * @param {string} attr Attribute name.
     * @returns {*} Attribute value if available, fallback value or undefined
     * otherwise.
     * @protected
     */

  }, {
    key: '_getAttributeValue',
    value: function _getAttributeValue(attr) {
      return (0, _scalesUtils.getAttributeValue)(this.props, attr);
    }

    /**
     * Get the scale object distance by the attribute from the list of properties.
     * @param {string} attr Attribute name.
     * @returns {number} Scale distance.
     * @protected
     */

  }, {
    key: '_getScaleDistance',
    value: function _getScaleDistance(attr) {
      var scaleObject = (0, _scalesUtils.getScaleObjectFromProps)(this.props, attr);
      return scaleObject ? scaleObject.distance : 0;
    }
  }, {
    key: '_getXCoordinateInContainer',
    value: function _getXCoordinateInContainer(event) {
      var _props$marginLeft = this.props.marginLeft,
          marginLeft = _props$marginLeft === undefined ? 0 : _props$marginLeft;
      var clientX = event.nativeEvent.clientX,
          currentTarget = event.currentTarget;

      var rect = currentTarget.getBoundingClientRect();
      return clientX - rect.left - currentTarget.clientLeft - marginLeft;
    }
  }, {
    key: 'onParentMouseMove',
    value: function onParentMouseMove(event) {
      var _props4 = this.props,
          onNearestX = _props4.onNearestX,
          data = _props4.data;

      if (!onNearestX || !data) {
        return;
      }
      var minDistance = Number.POSITIVE_INFINITY;
      var value = null;
      var valueIndex = null;

      var coordinate = this._getXCoordinateInContainer(event);
      var xScaleFn = this._getAttributeFunctor('x');

      data.forEach(function (item, i) {
        var currentCoordinate = xScaleFn(item);
        var newDistance = Math.abs(coordinate - currentCoordinate);
        if (newDistance < minDistance) {
          minDistance = newDistance;
          value = item;
          valueIndex = i;
        }
      });
      if (!value) {
        return;
      }
      onNearestX(value, {
        innerX: xScaleFn(value),
        index: valueIndex,
        event: event.nativeEvent
      });
    }
  }], [{
    key: 'getParentConfig',


    /**
     * Get a default config for the parent.
     * @returns {Object} Empty config.
     */
    value: function getParentConfig() {
      return {};
    }
  }, {
    key: 'requiresSVG',
    get: function get() {
      return true;
    }
  }]);

  return AbstractSeries;
}(_pureRenderComponent2.default);

AbstractSeries.displayName = 'AbstractSeries';
AbstractSeries.propTypes = propTypes;
AbstractSeries.defaultProps = defaultProps;

exports.default = AbstractSeries;