'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _abstractSeries = require('./abstract-series');

var _abstractSeries2 = _interopRequireDefault(_abstractSeries);

var _theme = require('../../theme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var predefinedClassName = 'rv-label__series';
var predefinedLabelClassName = 'rv-label__series--item';

function textFunctor(d) {
  return d.label;
}

var DEFAULT_FONT_SIZE = '12';

var LabelSeries = function (_AbstractSeries) {
  _inherits(LabelSeries, _AbstractSeries);

  function LabelSeries() {
    _classCallCheck(this, LabelSeries);

    return _possibleConstructorReturn(this, (LabelSeries.__proto__ || Object.getPrototypeOf(LabelSeries)).apply(this, arguments));
  }

  _createClass(LabelSeries, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          data = _props.data,
          marginLeft = _props.marginLeft,
          marginTop = _props.marginTop;

      if (!data) {
        return null;
      }

      var opacityFunctor = this._getAttributeFunctor('opacity');
      var fillFunctor = this._getAttributeFunctor('fill') || this._getAttributeFunctor('color');
      var strokeFunctor = this._getAttributeFunctor('stroke') || this._getAttributeFunctor('color');
      var xFunctor = this._getAttributeFunctor('x');
      var yFunctor = this._getAttributeFunctor('y');
      var sizeFunctor = this._getAttributeFunctor('size');

      return _react2.default.createElement(
        'g',
        { className: predefinedClassName + ' ' + className,
          ref: 'container',
          transform: 'translate(' + marginLeft + ',' + marginTop + ')' },
        data.map(function (d, i) {
          var attrs = {
            style: {
              opacity: opacityFunctor ? opacityFunctor(d) : _theme.DEFAULT_OPACITY,
              stroke: strokeFunctor && strokeFunctor(d),
              fill: fillFunctor && fillFunctor(d)
            },
            className: predefinedLabelClassName,
            fontSize: sizeFunctor ? sizeFunctor(d) : DEFAULT_FONT_SIZE,
            x: xFunctor(d),
            y: yFunctor(d),
            key: i,
            onClick: function onClick(e) {
              return _this2._valueClickHandler(d, e);
            },
            onMouseOver: function onMouseOver(e) {
              return _this2._valueMouseOverHandler(d, e);
            },
            onMouseOut: function onMouseOut(e) {
              return _this2._valueMouseOutHandler(d, e);
            }
          };
          return _react2.default.createElement(
            'text',
            attrs,
            textFunctor(d)
          );
        })
      );
    }
  }]);

  return LabelSeries;
}(_abstractSeries2.default);

LabelSeries.displayName = 'LabelSeries';

exports.default = LabelSeries;
//# sourceMappingURL=data:application/json;base64,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