'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _abstractSeries = require('./abstract-series');

var _abstractSeries2 = _interopRequireDefault(_abstractSeries);

var _animation = require('../../animation');

var _animation2 = _interopRequireDefault(_animation);

var _seriesUtils = require('../../utils/series-utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var predefinedClassName = 'rv-xy-plot__series rv-xy-plot__series--bar';

var BarSeries = function (_AbstractSeries) {
  _inherits(BarSeries, _AbstractSeries);

  function BarSeries() {
    _classCallCheck(this, BarSeries);

    return _possibleConstructorReturn(this, (BarSeries.__proto__ || Object.getPrototypeOf(BarSeries)).apply(this, arguments));
  }

  _createClass(BarSeries, [{
    key: '_getScackParams',
    value: function _getScackParams() {
      var _props = this.props,
          _stackBy = _props._stackBy,
          valuePosAttr = _props.valuePosAttr;
      var _props2 = this.props,
          _props2$sameTypeTotal = _props2.sameTypeTotal,
          sameTypeTotal = _props2$sameTypeTotal === undefined ? 1 : _props2$sameTypeTotal,
          _props2$sameTypeIndex = _props2.sameTypeIndex,
          sameTypeIndex = _props2$sameTypeIndex === undefined ? 0 : _props2$sameTypeIndex;

      if (_stackBy === valuePosAttr) {
        sameTypeTotal = 1;
        sameTypeIndex = 0;
      }
      return { sameTypeTotal: sameTypeTotal, sameTypeIndex: sameTypeIndex };
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props3 = this.props,
          animation = _props3.animation,
          className = _props3.className,
          data = _props3.data,
          linePosAttr = _props3.linePosAttr,
          lineSizeAttr = _props3.lineSizeAttr,
          marginLeft = _props3.marginLeft,
          marginTop = _props3.marginTop,
          valuePosAttr = _props3.valuePosAttr,
          valueSizeAttr = _props3.valueSizeAttr;


      if (!data) {
        return null;
      }

      if (animation) {
        return _react2.default.createElement(
          _animation2.default,
          _extends({}, this.props, { animatedProps: _seriesUtils.ANIMATED_SERIES_PROPS }),
          _react2.default.createElement(BarSeries, _extends({}, this.props, { animation: null }))
        );
      }
      console.log('here');
      // const {sameTypeTotal, sameTypeIndex} = this._getScackParams();

      var lineFunctor = this._getAttributeFunctor(linePosAttr);
      var line0Functor = this._getAttr0Functor(linePosAttr);

      var valueFunctor = this._getAttributeFunctor(valuePosAttr);
      var value0Functor = this._getAttr0Functor(valuePosAttr);

      var fillFunctor = this._getAttributeFunctor('fill') || this._getAttributeFunctor('color');
      var strokeFunctor = this._getAttributeFunctor('stroke') || this._getAttributeFunctor('color');
      var opacityFunctor = this._getAttributeFunctor('opacity');

      return _react2.default.createElement(
        'g',
        { className: predefinedClassName + ' ' + className,
          ref: 'container',
          transform: 'translate(' + marginLeft + ',' + marginTop + ')' },
        data.map(function (d, i) {
          var _attrs;

          var attrs = (_attrs = {
            style: {
              opacity: opacityFunctor && opacityFunctor(d),
              stroke: strokeFunctor && strokeFunctor(d),
              fill: fillFunctor && fillFunctor(d)
            }
          }, _defineProperty(_attrs, linePosAttr, line0Functor(d)), _defineProperty(_attrs, lineSizeAttr, lineFunctor(d) - line0Functor(d)), _defineProperty(_attrs, valuePosAttr, Math.min(value0Functor(d), valueFunctor(d))), _defineProperty(_attrs, valueSizeAttr, Math.abs(-value0Functor(d) + valueFunctor(d))), _defineProperty(_attrs, 'onClick', function onClick(e) {
            return _this2._valueClickHandler(d, e);
          }), _defineProperty(_attrs, 'onMouseOver', function onMouseOver(e) {
            return _this2._valueMouseOverHandler(d, e);
          }), _defineProperty(_attrs, 'onMouseOut', function onMouseOut(e) {
            return _this2._valueMouseOutHandler(d, e);
          }), _defineProperty(_attrs, 'key', i), _attrs);
          return _react2.default.createElement('rect', attrs);
        })
      );
    }
  }], [{
    key: 'propTypes',
    get: function get() {
      return _extends({}, _abstractSeries2.default.propTypes, {
        linePosAttr: _react2.default.PropTypes.string,
        valuePosAttr: _react2.default.PropTypes.string,
        lineSizeAttr: _react2.default.PropTypes.string,
        valueSizeAttr: _react2.default.PropTypes.string
      });
    }
  }]);

  return BarSeries;
}(_abstractSeries2.default);

BarSeries.displayName = 'BarSeries';

exports.default = BarSeries;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvcGxvdC9zZXJpZXMvcmVjdGFuZ2xlLXNlcmllcy5qcyJdLCJuYW1lcyI6WyJwcmVkZWZpbmVkQ2xhc3NOYW1lIiwiQmFyU2VyaWVzIiwicHJvcHMiLCJfc3RhY2tCeSIsInZhbHVlUG9zQXR0ciIsInNhbWVUeXBlVG90YWwiLCJzYW1lVHlwZUluZGV4IiwiYW5pbWF0aW9uIiwiY2xhc3NOYW1lIiwiZGF0YSIsImxpbmVQb3NBdHRyIiwibGluZVNpemVBdHRyIiwibWFyZ2luTGVmdCIsIm1hcmdpblRvcCIsInZhbHVlU2l6ZUF0dHIiLCJjb25zb2xlIiwibG9nIiwibGluZUZ1bmN0b3IiLCJfZ2V0QXR0cmlidXRlRnVuY3RvciIsImxpbmUwRnVuY3RvciIsIl9nZXRBdHRyMEZ1bmN0b3IiLCJ2YWx1ZUZ1bmN0b3IiLCJ2YWx1ZTBGdW5jdG9yIiwiZmlsbEZ1bmN0b3IiLCJzdHJva2VGdW5jdG9yIiwib3BhY2l0eUZ1bmN0b3IiLCJtYXAiLCJkIiwiaSIsImF0dHJzIiwic3R5bGUiLCJvcGFjaXR5Iiwic3Ryb2tlIiwiZmlsbCIsIk1hdGgiLCJtaW4iLCJhYnMiLCJfdmFsdWVDbGlja0hhbmRsZXIiLCJlIiwiX3ZhbHVlTW91c2VPdmVySGFuZGxlciIsIl92YWx1ZU1vdXNlT3V0SGFuZGxlciIsInByb3BUeXBlcyIsIlByb3BUeXBlcyIsInN0cmluZyIsImRpc3BsYXlOYW1lIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBb0JBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7Ozs7Ozs7OytlQXZCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFPQSxJQUFNQSxzQkFBc0IsNENBQTVCOztJQUVNQyxTOzs7Ozs7Ozs7OztzQ0FZYztBQUFBLG1CQUNpQixLQUFLQyxLQUR0QjtBQUFBLFVBQ1RDLFFBRFMsVUFDVEEsUUFEUztBQUFBLFVBQ0NDLFlBREQsVUFDQ0EsWUFERDtBQUFBLG9CQUtaLEtBQUtGLEtBTE87QUFBQSwwQ0FHZEcsYUFIYztBQUFBLFVBR2RBLGFBSGMseUNBR0UsQ0FIRjtBQUFBLDBDQUlkQyxhQUpjO0FBQUEsVUFJZEEsYUFKYyx5Q0FJRSxDQUpGOztBQU1oQixVQUFJSCxhQUFhQyxZQUFqQixFQUErQjtBQUM3QkMsd0JBQWdCLENBQWhCO0FBQ0FDLHdCQUFnQixDQUFoQjtBQUNEO0FBQ0QsYUFBTyxFQUFDRCw0QkFBRCxFQUFnQkMsNEJBQWhCLEVBQVA7QUFDRDs7OzZCQUVRO0FBQUE7O0FBQUEsb0JBV0gsS0FBS0osS0FYRjtBQUFBLFVBRUxLLFNBRkssV0FFTEEsU0FGSztBQUFBLFVBR0xDLFNBSEssV0FHTEEsU0FISztBQUFBLFVBSUxDLElBSkssV0FJTEEsSUFKSztBQUFBLFVBS0xDLFdBTEssV0FLTEEsV0FMSztBQUFBLFVBTUxDLFlBTkssV0FNTEEsWUFOSztBQUFBLFVBT0xDLFVBUEssV0FPTEEsVUFQSztBQUFBLFVBUUxDLFNBUkssV0FRTEEsU0FSSztBQUFBLFVBU0xULFlBVEssV0FTTEEsWUFUSztBQUFBLFVBVUxVLGFBVkssV0FVTEEsYUFWSzs7O0FBYVAsVUFBSSxDQUFDTCxJQUFMLEVBQVc7QUFDVCxlQUFPLElBQVA7QUFDRDs7QUFFRCxVQUFJRixTQUFKLEVBQWU7QUFDYixlQUNFO0FBQUE7QUFBQSx1QkFBZSxLQUFLTCxLQUFwQixJQUEyQixpREFBM0I7QUFDRSx3Q0FBQyxTQUFELGVBQWUsS0FBS0EsS0FBcEIsSUFBMkIsV0FBVyxJQUF0QztBQURGLFNBREY7QUFLRDtBQUNEYSxjQUFRQyxHQUFSLENBQVksTUFBWjtBQUNBOztBQUVBLFVBQU1DLGNBQWMsS0FBS0Msb0JBQUwsQ0FBMEJSLFdBQTFCLENBQXBCO0FBQ0EsVUFBTVMsZUFBZSxLQUFLQyxnQkFBTCxDQUFzQlYsV0FBdEIsQ0FBckI7O0FBRUEsVUFBTVcsZUFBZSxLQUFLSCxvQkFBTCxDQUEwQmQsWUFBMUIsQ0FBckI7QUFDQSxVQUFNa0IsZ0JBQWdCLEtBQUtGLGdCQUFMLENBQXNCaEIsWUFBdEIsQ0FBdEI7O0FBRUEsVUFBTW1CLGNBQWMsS0FBS0wsb0JBQUwsQ0FBMEIsTUFBMUIsS0FDbEIsS0FBS0Esb0JBQUwsQ0FBMEIsT0FBMUIsQ0FERjtBQUVBLFVBQU1NLGdCQUFnQixLQUFLTixvQkFBTCxDQUEwQixRQUExQixLQUNwQixLQUFLQSxvQkFBTCxDQUEwQixPQUExQixDQURGO0FBRUEsVUFBTU8saUJBQWlCLEtBQUtQLG9CQUFMLENBQTBCLFNBQTFCLENBQXZCOztBQUVBLGFBQ0U7QUFBQTtBQUFBLFVBQUcsV0FBY2xCLG1CQUFkLFNBQXFDUSxTQUF4QztBQUNFLGVBQUksV0FETjtBQUVFLG9DQUF3QkksVUFBeEIsU0FBc0NDLFNBQXRDLE1BRkY7QUFHR0osYUFBS2lCLEdBQUwsQ0FBUyxVQUFDQyxDQUFELEVBQUlDLENBQUosRUFBVTtBQUFBOztBQUNsQixjQUFNQztBQUNKQyxtQkFBTztBQUNMQyx1QkFBU04sa0JBQWtCQSxlQUFlRSxDQUFmLENBRHRCO0FBRUxLLHNCQUFRUixpQkFBaUJBLGNBQWNHLENBQWQsQ0FGcEI7QUFHTE0sb0JBQU1WLGVBQWVBLFlBQVlJLENBQVo7QUFIaEI7QUFESCxxQ0FNSGpCLFdBTkcsRUFNV1MsYUFBYVEsQ0FBYixDQU5YLDJCQU9IaEIsWUFQRyxFQU9ZTSxZQUFZVSxDQUFaLElBQWlCUixhQUFhUSxDQUFiLENBUDdCLDJCQVFIdkIsWUFSRyxFQVFZOEIsS0FBS0MsR0FBTCxDQUFTYixjQUFjSyxDQUFkLENBQVQsRUFBMkJOLGFBQWFNLENBQWIsQ0FBM0IsQ0FSWiwyQkFTSGIsYUFURyxFQVNhb0IsS0FBS0UsR0FBTCxDQUFTLENBQUNkLGNBQWNLLENBQWQsQ0FBRCxHQUFvQk4sYUFBYU0sQ0FBYixDQUE3QixDQVRiLHNDQVVLO0FBQUEsbUJBQUssT0FBS1Usa0JBQUwsQ0FBd0JWLENBQXhCLEVBQTJCVyxDQUEzQixDQUFMO0FBQUEsV0FWTCwwQ0FXUztBQUFBLG1CQUFLLE9BQUtDLHNCQUFMLENBQTRCWixDQUE1QixFQUErQlcsQ0FBL0IsQ0FBTDtBQUFBLFdBWFQseUNBWVE7QUFBQSxtQkFBSyxPQUFLRSxxQkFBTCxDQUEyQmIsQ0FBM0IsRUFBOEJXLENBQTlCLENBQUw7QUFBQSxXQVpSLGtDQWFDVixDQWJELFVBQU47QUFlQSxpQkFBUSxzQ0FBVUMsS0FBVixDQUFSO0FBQ0QsU0FqQkE7QUFISCxPQURGO0FBd0JEOzs7d0JBdEZzQjtBQUNyQiwwQkFDTSx5QkFBZVksU0FEckI7QUFFRS9CLHFCQUFhLGdCQUFNZ0MsU0FBTixDQUFnQkMsTUFGL0I7QUFHRXZDLHNCQUFjLGdCQUFNc0MsU0FBTixDQUFnQkMsTUFIaEM7QUFJRWhDLHNCQUFjLGdCQUFNK0IsU0FBTixDQUFnQkMsTUFKaEM7QUFLRTdCLHVCQUFlLGdCQUFNNEIsU0FBTixDQUFnQkM7QUFMakM7QUFPRDs7Ozs7O0FBaUZIMUMsVUFBVTJDLFdBQVYsR0FBd0IsV0FBeEI7O2tCQUVlM0MsUyIsImZpbGUiOiJyZWN0YW5nbGUtc2VyaWVzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE2IFViZXIgVGVjaG5vbG9naWVzLCBJbmMuXG4vL1xuLy8gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuLy8gb2YgdGhpcyBzb2Z0d2FyZSBhbmQgYXNzb2NpYXRlZCBkb2N1bWVudGF0aW9uIGZpbGVzICh0aGUgXCJTb2Z0d2FyZVwiKSwgdG8gZGVhbFxuLy8gaW4gdGhlIFNvZnR3YXJlIHdpdGhvdXQgcmVzdHJpY3Rpb24sIGluY2x1ZGluZyB3aXRob3V0IGxpbWl0YXRpb24gdGhlIHJpZ2h0c1xuLy8gdG8gdXNlLCBjb3B5LCBtb2RpZnksIG1lcmdlLCBwdWJsaXNoLCBkaXN0cmlidXRlLCBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbFxuLy8gY29waWVzIG9mIHRoZSBTb2Z0d2FyZSwgYW5kIHRvIHBlcm1pdCBwZXJzb25zIHRvIHdob20gdGhlIFNvZnR3YXJlIGlzXG4vLyBmdXJuaXNoZWQgdG8gZG8gc28sIHN1YmplY3QgdG8gdGhlIGZvbGxvd2luZyBjb25kaXRpb25zOlxuLy9cbi8vIFRoZSBhYm92ZSBjb3B5cmlnaHQgbm90aWNlIGFuZCB0aGlzIHBlcm1pc3Npb24gbm90aWNlIHNoYWxsIGJlIGluY2x1ZGVkIGluXG4vLyBhbGwgY29waWVzIG9yIHN1YnN0YW50aWFsIHBvcnRpb25zIG9mIHRoZSBTb2Z0d2FyZS5cbi8vXG4vLyBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4vLyBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbi8vIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuLy8gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuLy8gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbi8vIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbi8vIFRIRSBTT0ZUV0FSRS5cblxuaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBBYnN0cmFjdFNlcmllcyBmcm9tICcuL2Fic3RyYWN0LXNlcmllcyc7XG5pbXBvcnQgQW5pbWF0aW9uIGZyb20gJy4uLy4uL2FuaW1hdGlvbic7XG5pbXBvcnQge0FOSU1BVEVEX1NFUklFU19QUk9QU30gZnJvbSAnLi4vLi4vdXRpbHMvc2VyaWVzLXV0aWxzJztcblxuY29uc3QgcHJlZGVmaW5lZENsYXNzTmFtZSA9ICdydi14eS1wbG90X19zZXJpZXMgcnYteHktcGxvdF9fc2VyaWVzLS1iYXInO1xuXG5jbGFzcyBCYXJTZXJpZXMgZXh0ZW5kcyBBYnN0cmFjdFNlcmllcyB7XG5cbiAgc3RhdGljIGdldCBwcm9wVHlwZXMoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLiBBYnN0cmFjdFNlcmllcy5wcm9wVHlwZXMsXG4gICAgICBsaW5lUG9zQXR0cjogUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIHZhbHVlUG9zQXR0cjogUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIGxpbmVTaXplQXR0cjogUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgIHZhbHVlU2l6ZUF0dHI6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmdcbiAgICB9O1xuICB9XG5cbiAgX2dldFNjYWNrUGFyYW1zKCkge1xuICAgIGNvbnN0IHtfc3RhY2tCeSwgdmFsdWVQb3NBdHRyfSA9IHRoaXMucHJvcHM7XG4gICAgbGV0IHtcbiAgICAgIHNhbWVUeXBlVG90YWwgPSAxLFxuICAgICAgc2FtZVR5cGVJbmRleCA9IDBcbiAgICB9ID0gdGhpcy5wcm9wcztcbiAgICBpZiAoX3N0YWNrQnkgPT09IHZhbHVlUG9zQXR0cikge1xuICAgICAgc2FtZVR5cGVUb3RhbCA9IDE7XG4gICAgICBzYW1lVHlwZUluZGV4ID0gMDtcbiAgICB9XG4gICAgcmV0dXJuIHtzYW1lVHlwZVRvdGFsLCBzYW1lVHlwZUluZGV4fTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7XG4gICAgICBhbmltYXRpb24sXG4gICAgICBjbGFzc05hbWUsXG4gICAgICBkYXRhLFxuICAgICAgbGluZVBvc0F0dHIsXG4gICAgICBsaW5lU2l6ZUF0dHIsXG4gICAgICBtYXJnaW5MZWZ0LFxuICAgICAgbWFyZ2luVG9wLFxuICAgICAgdmFsdWVQb3NBdHRyLFxuICAgICAgdmFsdWVTaXplQXR0clxuICAgIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgaWYgKCFkYXRhKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICBpZiAoYW5pbWF0aW9uKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8QW5pbWF0aW9uIHsuLi50aGlzLnByb3BzfSBhbmltYXRlZFByb3BzPXtBTklNQVRFRF9TRVJJRVNfUFJPUFN9PlxuICAgICAgICAgIDxCYXJTZXJpZXMgey4uLnRoaXMucHJvcHN9IGFuaW1hdGlvbj17bnVsbH0vPlxuICAgICAgICA8L0FuaW1hdGlvbj5cbiAgICAgICk7XG4gICAgfVxuICAgIGNvbnNvbGUubG9nKCdoZXJlJylcbiAgICAvLyBjb25zdCB7c2FtZVR5cGVUb3RhbCwgc2FtZVR5cGVJbmRleH0gPSB0aGlzLl9nZXRTY2Fja1BhcmFtcygpO1xuXG4gICAgY29uc3QgbGluZUZ1bmN0b3IgPSB0aGlzLl9nZXRBdHRyaWJ1dGVGdW5jdG9yKGxpbmVQb3NBdHRyKTtcbiAgICBjb25zdCBsaW5lMEZ1bmN0b3IgPSB0aGlzLl9nZXRBdHRyMEZ1bmN0b3IobGluZVBvc0F0dHIpO1xuXG4gICAgY29uc3QgdmFsdWVGdW5jdG9yID0gdGhpcy5fZ2V0QXR0cmlidXRlRnVuY3Rvcih2YWx1ZVBvc0F0dHIpO1xuICAgIGNvbnN0IHZhbHVlMEZ1bmN0b3IgPSB0aGlzLl9nZXRBdHRyMEZ1bmN0b3IodmFsdWVQb3NBdHRyKTtcblxuICAgIGNvbnN0IGZpbGxGdW5jdG9yID0gdGhpcy5fZ2V0QXR0cmlidXRlRnVuY3RvcignZmlsbCcpIHx8XG4gICAgICB0aGlzLl9nZXRBdHRyaWJ1dGVGdW5jdG9yKCdjb2xvcicpO1xuICAgIGNvbnN0IHN0cm9rZUZ1bmN0b3IgPSB0aGlzLl9nZXRBdHRyaWJ1dGVGdW5jdG9yKCdzdHJva2UnKSB8fFxuICAgICAgdGhpcy5fZ2V0QXR0cmlidXRlRnVuY3RvcignY29sb3InKTtcbiAgICBjb25zdCBvcGFjaXR5RnVuY3RvciA9IHRoaXMuX2dldEF0dHJpYnV0ZUZ1bmN0b3IoJ29wYWNpdHknKTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZyBjbGFzc05hbWU9e2Ake3ByZWRlZmluZWRDbGFzc05hbWV9ICR7Y2xhc3NOYW1lfWB9XG4gICAgICAgIHJlZj1cImNvbnRhaW5lclwiXG4gICAgICAgIHRyYW5zZm9ybT17YHRyYW5zbGF0ZSgke21hcmdpbkxlZnR9LCR7bWFyZ2luVG9wfSlgfT5cbiAgICAgICAge2RhdGEubWFwKChkLCBpKSA9PiB7XG4gICAgICAgICAgY29uc3QgYXR0cnMgPSB7XG4gICAgICAgICAgICBzdHlsZToge1xuICAgICAgICAgICAgICBvcGFjaXR5OiBvcGFjaXR5RnVuY3RvciAmJiBvcGFjaXR5RnVuY3RvcihkKSxcbiAgICAgICAgICAgICAgc3Ryb2tlOiBzdHJva2VGdW5jdG9yICYmIHN0cm9rZUZ1bmN0b3IoZCksXG4gICAgICAgICAgICAgIGZpbGw6IGZpbGxGdW5jdG9yICYmIGZpbGxGdW5jdG9yKGQpXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgW2xpbmVQb3NBdHRyXTogbGluZTBGdW5jdG9yKGQpLFxuICAgICAgICAgICAgW2xpbmVTaXplQXR0cl06IGxpbmVGdW5jdG9yKGQpIC0gbGluZTBGdW5jdG9yKGQpLFxuICAgICAgICAgICAgW3ZhbHVlUG9zQXR0cl06IE1hdGgubWluKHZhbHVlMEZ1bmN0b3IoZCksIHZhbHVlRnVuY3RvcihkKSksXG4gICAgICAgICAgICBbdmFsdWVTaXplQXR0cl06IE1hdGguYWJzKC12YWx1ZTBGdW5jdG9yKGQpICsgdmFsdWVGdW5jdG9yKGQpKSxcbiAgICAgICAgICAgIG9uQ2xpY2s6IGUgPT4gdGhpcy5fdmFsdWVDbGlja0hhbmRsZXIoZCwgZSksXG4gICAgICAgICAgICBvbk1vdXNlT3ZlcjogZSA9PiB0aGlzLl92YWx1ZU1vdXNlT3ZlckhhbmRsZXIoZCwgZSksXG4gICAgICAgICAgICBvbk1vdXNlT3V0OiBlID0+IHRoaXMuX3ZhbHVlTW91c2VPdXRIYW5kbGVyKGQsIGUpLFxuICAgICAgICAgICAga2V5OiBpXG4gICAgICAgICAgfTtcbiAgICAgICAgICByZXR1cm4gKDxyZWN0IHsuLi5hdHRyc30gLz4pO1xuICAgICAgICB9KX1cbiAgICAgIDwvZz5cbiAgICApO1xuICB9XG59XG5cbkJhclNlcmllcy5kaXNwbGF5TmFtZSA9ICdCYXJTZXJpZXMnO1xuXG5leHBvcnQgZGVmYXVsdCBCYXJTZXJpZXM7XG4iXX0=