'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _d3Hierarchy = require('d3-hierarchy');

var d3Hierarchy = _interopRequireWildcard(_d3Hierarchy);

var _d3Color = require('d3-color');

var d3Color = _interopRequireWildcard(_d3Color);

var _animationUtils = require('../utils/animation-utils');

var _animation = require('../animation');

var _animation2 = _interopRequireDefault(_animation);

var _scalesUtils = require('../utils/scales-utils');

var _theme = require('../theme');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2016 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var TREEMAP_TILE_MODES = {
  squarify: d3Hierarchy.treemapSquarify,
  slice: d3Hierarchy.treemapSlice,
  dice: d3Hierarchy.treemapDice,
  slicedice: d3Hierarchy.treemapSliceDice
};

function getFontColorFromBackground(background) {
  if (background) {
    return d3Color.hsl(background).l > 0.57 ? '#222' : '#fff';
  }
  return null;
}

var ATTRIBUTES = ['opacity', 'color'];
var ANIMATED_PROPS = ['colorRange', 'colorDomain', 'color', 'opacityRange', 'opacityDomain', 'opacity'];

var Treemap = function (_React$Component) {
  _inherits(Treemap, _React$Component);

  _createClass(Treemap, null, [{
    key: 'propTypes',
    get: function get() {
      return {
        animation: _animationUtils.AnimationPropType,
        data: _react2.default.PropTypes.object.isRequired,
        height: _react2.default.PropTypes.number.isRequired,
        mode: _react2.default.PropTypes.oneOf(Object.keys(TREEMAP_TILE_MODES)),
        padding: _react2.default.PropTypes.number.isRequired,
        width: _react2.default.PropTypes.number.isRequired
      };
    }
  }, {
    key: 'defaultProps',
    get: function get() {
      return {
        className: '',
        colorRange: _theme.CONTINUOUS_COLOR_RANGE,
        _colorValue: _theme.DEFAULT_COLOR,
        data: {
          children: []
        },
        mode: 'squarify',
        opacityRange: _theme.OPACITY_RANGE,
        _opacityValue: 1,
        padding: 1
      };
    }
  }]);

  function Treemap(props) {
    _classCallCheck(this, Treemap);

    var _this = _possibleConstructorReturn(this, (Treemap.__proto__ || Object.getPrototypeOf(Treemap)).call(this, props));

    _this._renderLeaf = _this._renderLeaf.bind(_this);
    _this.state = { scales: _this._getScaleFns(props) };
    return _this;
  }

  _createClass(Treemap, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(props) {
      this.setState({ scales: this._getScaleFns(props) });
    }

    /**
     * Get the map of scale functions from the given props.
     * @param {Object} props Props for the component.
     * @returns {Object} Map of scale functions.
     * @private
     */

  }, {
    key: '_getScaleFns',
    value: function _getScaleFns(props) {
      var data = props.data;

      var allData = data.children || [];

      // Adding _allData property to the object to reuse the existing
      // getAttributeFunctor function.
      var compatibleProps = _extends({}, props, (0, _scalesUtils.getMissingScaleProps)(props, allData, ATTRIBUTES), {
        _allData: allData
      });
      return {
        opacity: (0, _scalesUtils.getAttributeFunctor)(compatibleProps, 'opacity'),
        color: (0, _scalesUtils.getAttributeFunctor)(compatibleProps, 'color')
      };
    }

    /**
     * Create the list of nodes to render.
     * @returns {Array} Array of nodes.
     * @private
     */

  }, {
    key: '_getNodesToRender',
    value: function _getNodesToRender() {
      var _props = this.props,
          data = _props.data,
          height = _props.height,
          width = _props.width,
          mode = _props.mode,
          padding = _props.padding;


      if (data) {
        var tileFn = TREEMAP_TILE_MODES[mode];
        return d3Hierarchy.treemap(tileFn).tile(d3Hierarchy.treemapSquarify).size([width, height]).padding(padding)(d3Hierarchy.hierarchy(data).sort(function (a, b) {
          return a.size - b.size;
        }).sum(function (d) {
          return d.size;
        })).descendants();
      }
      return [];
    }
  }, {
    key: '_renderLeaf',
    value: function _renderLeaf(node, i) {
      if (!i) {
        return null;
      }
      var scales = this.state.scales;


      var background = scales.color(node);
      var opacity = scales.opacity(node);
      var color = getFontColorFromBackground(background);
      var x0 = node.x0,
          x1 = node.x1,
          y0 = node.y0,
          y1 = node.y1,
          title = node.data.title;

      return _react2.default.createElement(
        'div',
        {
          key: i,
          className: 'rv-treemap__leaf',
          style: {
            top: y0 + 'px',
            left: x0 + 'px',
            width: x1 - x0 + 'px',
            height: y1 - y0 + 'px',
            background: background,
            opacity: opacity,
            color: color
          } },
        _react2.default.createElement(
          'div',
          { className: 'rv-treemap__leaf__content' },
          title
        )
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          animation = _props2.animation,
          className = _props2.className,
          height = _props2.height,
          width = _props2.width;

      var nodes = this._getNodesToRender();
      if (animation) {
        return _react2.default.createElement(
          _animation2.default,
          _extends({}, this.props, { animatedProps: ANIMATED_PROPS }),
          _react2.default.createElement(Treemap, _extends({}, this.props, { animation: null }))
        );
      }
      return _react2.default.createElement(
        'div',
        {
          className: 'rv-treemap ' + className,
          style: {
            width: width + 'px',
            height: height + 'px'
          } },
        nodes.map(this._renderLeaf)
      );
    }
  }]);

  return Treemap;
}(_react2.default.Component);

Treemap.displayName = 'Treemap';

exports.default = Treemap;