var assert = require('assert');

function newCheck (rect, containmentRect) {
  var partialVisible =
      rect.top <= containmentRect.bottom && rect.bottom >= containmentRect.top &&
      rect.left <= containmentRect.right && rect.right >= containmentRect.left;

  return partialVisible
}

function oldCheck (rect, containmentRect) {
  var partialVertical =
      (rect.top >= containmentRect.top && rect.top <= containmentRect.bottom)           // Top is visible
      || (rect.bottom >= containmentRect.top && rect.bottom <= containmentRect.bottom)  // Bottom is visible
      || (rect.top <= containmentRect.top && rect.bottom >= containmentRect.bottom);    // Center is visible

  var partialHorizontal =
      (rect.left >= containmentRect.left && rect.left <= containmentRect.right)         // Left side is visible
      || (rect.right >= containmentRect.left && rect.right <= containmentRect.right)    // Right side is visible
      || (rect.left <= containmentRect.left && rect.right >= containmentRect.right);    // Center is visible

  var partialVisible = partialVertical && partialHorizontal;

  return partialVisible;
}

describe('partialVisible check', function () {
  var containmentRect = {
    top: 0,
    left: 0,
    bottom: 100,
    right: 100
  }

  it('should count as visible when entirely inside container', function (done) {
    var rect = {
      top: 1,
      left: 1,
      bottom: 2,
      right: 2
    }
    assert.ok(newCheck(rect, containmentRect))
    assert.ok(oldCheck(rect, containmentRect))
    done()
  })

  it('should not count as visible when entirely outside container', function (done) {
    var rect = {
      top: 101,
      left: 101,
      bottom: 102,
      right: 102
    }
    assert.ok(!newCheck(rect, containmentRect))
    assert.ok(!oldCheck(rect, containmentRect))
    done()
  })

  it('should count as visible when overlapping container left edge', function (done) {
    var rect = {
      top: containmentRect.top + 1,
      left: containmentRect.left - 1,
      bottom: containmentRect.bottom - 1,
      right: containmentRect.left + 1
    }
    assert.ok(newCheck(rect, containmentRect))
    assert.ok(oldCheck(rect, containmentRect))
    done()
  })

  it('should count as visible when overlapping container right edge', function (done) {
    var rect = {
      top: containmentRect.top + 1,
      left: containmentRect.right - 1,
      bottom: containmentRect.bottom - 1,
      right: containmentRect.right + 1
    }
    assert.ok(newCheck(rect, containmentRect))
    assert.ok(oldCheck(rect, containmentRect))
    done()
  })

  it('should count as visible when overlapping container top edge', function (done) {
    var rect = {
      top: containmentRect.top - 1,
      left: containmentRect.left + 1,
      bottom: containmentRect.top + 1,
      right: containmentRect.right - 1
    }
    assert.ok(newCheck(rect, containmentRect))
    assert.ok(oldCheck(rect, containmentRect))
    done()
  })

  it('should count as visible when overlapping container bottom edge', function (done) {
    var rect = {
      top: containmentRect.bottom - 1,
      left: containmentRect.left + 1,
      bottom: containmentRect.bottom + 1,
      right: containmentRect.right - 1
    }
    assert.ok(newCheck(rect, containmentRect))
    assert.ok(oldCheck(rect, containmentRect))
    done()
  })
})
