/**
 * Copyright (c) 2015-present, Alibaba Group Holding Limited.
 * All rights reserved.
 *
 * @providesModule ReactWeb
 */
'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processColor = exports.Platform = exports.NativeModules = exports.StyleSheet = exports.PixelRatio = exports.PanResponder = exports.InteractionManager = exports.Easing = exports.Dimensions = exports.AsyncStorage = exports.AppRegistry = exports.Animated = exports.AlertIOS = exports.Alert = exports.ViewPagerAndroid = exports.View = exports.TouchableBounce = exports.TouchableWithoutFeedback = exports.TouchableOpacity = exports.TouchableHighlight = exports.Touchable = exports.ToastAndroid = exports.TextInput = exports.Text = exports.TabBarIOS = exports.SwitchIOS = exports.SwitchAndroid = exports.Switch = exports.SliderIOS = exports.SegmentedControlIOS = exports.ScrollView = exports.ProgressViewIOS = exports.PickerIOS = exports.Navigator = exports.Modal = exports.ListView = exports.Image = exports.DrawerLayoutAndroid = exports.ActivityIndicatorIOS = undefined;

var _react = require('react');

Object.keys(_react).forEach(function (key) {
  if (key === "default") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _react[key];
    }
  });
});

var _react2 = _interopRequireDefault(_react);

var _ReactStyleSheet = require('./StyleSheet/StyleSheet.web');

var _ReactStyleSheet2 = _interopRequireDefault(_ReactStyleSheet);

var _ReactActivityIndicator = require('./ActivityIndicator/ActivityIndicator.web');

var _ReactActivityIndicator2 = _interopRequireDefault(_ReactActivityIndicator);

var _ReactDrawerLayout = require('./DrawerLayout/DrawerLayout.web');

var _ReactDrawerLayout2 = _interopRequireDefault(_ReactDrawerLayout);

var _ReactImage = require('./Image/Image.web');

var _ReactImage2 = _interopRequireDefault(_ReactImage);

var _ReactListView = require('./ListView/ListView.web');

var _ReactListView2 = _interopRequireDefault(_ReactListView);

var _ReactModal = require('./Modal/Modal.web');

var _ReactModal2 = _interopRequireDefault(_ReactModal);

var _ReactNavigator = require('./Navigator/Navigator.web');

var _ReactNavigator2 = _interopRequireDefault(_ReactNavigator);

var _ReactPicker = require('./Picker/Picker.web');

var _ReactPicker2 = _interopRequireDefault(_ReactPicker);

var _ReactProgressView = require('./ProgressView/ProgressView.web');

var _ReactProgressView2 = _interopRequireDefault(_ReactProgressView);

var _ReactScrollView = require('./ScrollView/ScrollView.web');

var _ReactScrollView2 = _interopRequireDefault(_ReactScrollView);

var _ReactSegmentedControl = require('./SegmentedControl/SegmentedControl.web');

var _ReactSegmentedControl2 = _interopRequireDefault(_ReactSegmentedControl);

var _ReactSlider = require('./Slider/Slider.web');

var _ReactSlider2 = _interopRequireDefault(_ReactSlider);

var _ReactSwitch = require('./Switch/Switch.web');

var _ReactSwitch2 = _interopRequireDefault(_ReactSwitch);

var _ReactTabBar = require('./TabBar/TabBar.web');

var _ReactTabBar2 = _interopRequireDefault(_ReactTabBar);

var _ReactText = require('./Text/Text.web');

var _ReactText2 = _interopRequireDefault(_ReactText);

var _ReactTextInput = require('./TextInput/TextInput.web');

var _ReactTextInput2 = _interopRequireDefault(_ReactTextInput);

var _ReactToast = require('./Toast/Toast.web');

var _ReactToast2 = _interopRequireDefault(_ReactToast);

var _ReactTouchable = require('./Touchable/Touchable');

var _ReactTouchable2 = _interopRequireDefault(_ReactTouchable);

var _ReactTouchableHighlight = require('./Touchable/TouchableHighlight.web');

var _ReactTouchableHighlight2 = _interopRequireDefault(_ReactTouchableHighlight);

var _ReactTouchableOpacity = require('./Touchable/TouchableOpacity.web');

var _ReactTouchableOpacity2 = _interopRequireDefault(_ReactTouchableOpacity);

var _ReactTouchableWithoutFeedback = require('./Touchable/TouchableWithoutFeedback.web');

var _ReactTouchableWithoutFeedback2 = _interopRequireDefault(_ReactTouchableWithoutFeedback);

var _ReactTouchableBounce = require('./Touchable/TouchableBounce.web');

var _ReactTouchableBounce2 = _interopRequireDefault(_ReactTouchableBounce);

var _ReactView = require('./View/View.web');

var _ReactView2 = _interopRequireDefault(_ReactView);

var _ReactViewPager = require('./ViewPager/ViewPager.web');

var _ReactViewPager2 = _interopRequireDefault(_ReactViewPager);

var _ReactAlert = require('./Alert/Alert.web');

var _ReactAlert2 = _interopRequireDefault(_ReactAlert);

var _ReactAnimated = require('./Animated/Animated.web');

var _ReactAnimated2 = _interopRequireDefault(_ReactAnimated);

var _ReactAppRegistry = require('./AppRegistry/AppRegistry.web');

var _ReactAppRegistry2 = _interopRequireDefault(_ReactAppRegistry);

var _ReactAsyncStorage = require('./Storage/AsyncStorage.web');

var _ReactAsyncStorage2 = _interopRequireDefault(_ReactAsyncStorage);

var _ReactDimensions = require('./Dimensions/Dimensions.web');

var _ReactDimensions2 = _interopRequireDefault(_ReactDimensions);

var _Easing2 = require('animated/lib/Easing');

var _Easing3 = _interopRequireDefault(_Easing2);

var _ReactInteractionManager = require('./Interaction/InteractionManager.web');

var _ReactInteractionManager2 = _interopRequireDefault(_ReactInteractionManager);

var _ReactPanResponder = require('./PanResponder/PanResponder.web');

var _ReactPanResponder2 = _interopRequireDefault(_ReactPanResponder);

var _ReactPixelRatio = require('./PixelRatio/PixelRatio.web');

var _ReactPixelRatio2 = _interopRequireDefault(_ReactPixelRatio);

var _ReactNativeModules = require('./NativeModules/NativeModules.web');

var _ReactNativeModules2 = _interopRequireDefault(_ReactNativeModules);

var _ReactPlatform = require('./Platform/Platform.web');

var _ReactPlatform2 = _interopRequireDefault(_ReactPlatform);

var _ReactProcessColor = require('./StyleSheet/processColor.web');

var _ReactProcessColor2 = _interopRequireDefault(_ReactProcessColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// proxy origin react createElement
(0, _ReactStyleSheet.extendCreateElement)(_react2.default);

// React


// Components
exports.ActivityIndicatorIOS = _ReactActivityIndicator2.default;
// export DatePickerIOS from 'ReactDatePicker';

exports.DrawerLayoutAndroid = _ReactDrawerLayout2.default;
exports.Image = _ReactImage2.default;
exports.ListView = _ReactListView2.default;
exports.Modal = _ReactModal2.default;
exports.Navigator = _ReactNavigator2.default;
exports.PickerIOS = _ReactPicker2.default;
exports.ProgressViewIOS = _ReactProgressView2.default;
exports.ScrollView = _ReactScrollView2.default;
exports.SegmentedControlIOS = _ReactSegmentedControl2.default;
exports.SliderIOS = _ReactSlider2.default;
exports.Switch = _ReactSwitch2.default;
exports.SwitchAndroid = _ReactSwitch2.default;
exports.SwitchIOS = _ReactSwitch2.default;
exports.TabBarIOS = _ReactTabBar2.default;
exports.Text = _ReactText2.default;
exports.TextInput = _ReactTextInput2.default;
exports.ToastAndroid = _ReactToast2.default;
exports.Touchable = _ReactTouchable2.default;
exports.TouchableHighlight = _ReactTouchableHighlight2.default;
exports.TouchableOpacity = _ReactTouchableOpacity2.default;
exports.TouchableWithoutFeedback = _ReactTouchableWithoutFeedback2.default;
exports.TouchableBounce = _ReactTouchableBounce2.default;
exports.View = _ReactView2.default;
exports.ViewPagerAndroid = _ReactViewPager2.default;

// APIs

exports.Alert = _ReactAlert2.default;
exports.AlertIOS = _ReactAlert2.default;
exports.Animated = _ReactAnimated2.default;
exports.AppRegistry = _ReactAppRegistry2.default;
exports.AsyncStorage = _ReactAsyncStorage2.default;
exports.Dimensions = _ReactDimensions2.default;
exports.Easing = _Easing3.default;
exports.InteractionManager = _ReactInteractionManager2.default;
exports.PanResponder = _ReactPanResponder2.default;
exports.PixelRatio = _ReactPixelRatio2.default;
exports.StyleSheet = _ReactStyleSheet2.default;

// Plugins

exports.NativeModules = _ReactNativeModules2.default;
exports.Platform = _ReactPlatform2.default;
exports.processColor = _ReactProcessColor2.default;

// Match the react-native export signature, which uses CommonJS
// (not ES6), where this works:
//    import ReactNative, {View} from 'react-native';
//    ReactNative.View === View

exports.default = module.exports;