"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getClassName;

/**
 * Construct a class name.
 *
 * namespace {String} Used to construct unique class names.
 * styleName {String} Name identifying the specific style.
 *
 * Return the class name.
 */
function getClassName(namespace, styleName) {
  var namespaceSegment = namespace.length > 0 ? "".concat(namespace, "__") : '';
  return "".concat(namespaceSegment).concat(styleName);
}