---
id: getting-started-attach
title: Attach Styles to HTML

---
Lastly, attach the styles to the corresponding elements.

When attaching styles to a normal HTML element, set styles to the `this.styles().element` variable. When attaching styles to a custom component, set that same variable as a spread `{...this.styles().element}`:
``` javascript
var ReactCSS = require('reactcss');

class Button extends ReactCSS.Component {

  classes() {
    return {
      'default': {
        modal: {
          background: '#fff',
          boxShadow: '0 2px 4px rgba(0, 0, 0, .48)'
        },
        title: {
          fontSize: '24px'
        },
        Content: {
          type: 'modal-content',
          padding: '20px'
        }
      }  
    }
  }

  render() {
    return (
      <div styles={ this.styles().modal }>
        <div styles={ this.styles().title }>{ this.props.title }</div>
        <Content {...this.styles().Content} />
      </div>
    )
  }
}
```
It can be a cumbersome to remember the different style and spread declarations. The `react-map-styes` packages makes it simpler by leveraging the `is=""` prop syntax to map styles. Use a lowercase name for html elements `is="element"` and an uppercase name for custom component `is="Component"`:
```
var ReactCSS = require('reactcss');

class Button extends ReactCSS.Component {
  ...

  render() {
    return (
      <div is="modal">
        <div is="title">{ this.props.title }</div>
        <Content is="Content" />
      </div>
    )
  }
}
```
