---
id: getting-started-include
title: Include the File

---
Using the traditional ES5 syntax with `React.createClass`, you would include ReactCSS.inline as a mixin:
```javascript
var React = require('react');
var ReactCSS = require('reactcss');

var Button = React.createClass({
  mixins: [ ReactCSS.mixin ],

  styles: function(){
    return this.css()
  },

  ...
});
```

Using the new ES6 syntax, extend `ReactCSS.Component` instead of `React.Component`.
```javascript
var React = require('react');
var ReactCSS = require('reactcss');

class Button extends ReactCSS.Component {
  ...
}
```
