"use strict";

exports.__esModule = true;
exports["default"] = isNumeric;
var is_array = Array.isArray;

function isNumeric(val) {
    // parseFloat NaNs numeric-cast false positives (null|true|false|"")
    // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
    // subtraction forces infinities to NaN
    // adding 1 corrects loss of precision from parseFloat (#15100)
    return !is_array(val) && val - parseFloat(val) + 1 >= 0;
}

;
//# sourceMappingURL=isNumeric.js.map
module.exports = exports["default"];
//# sourceMappingURL=isNumeric.js.map