var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../util/isArray', '../util/isFunction', '../util/isPromise', '../util/isScheduler', './PromiseObservable', './IteratorObservable', './ArrayObservable', './ArrayLikeObservable', '../symbol/iterator', '../Observable', '../operator/observeOn', 'symbol-observable'], function (require, exports, isArray_1, isFunction_1, isPromise_1, isScheduler_1, PromiseObservable_1, IteratorObservable_1, ArrayObservable_1, ArrayLikeObservable_1, iterator_1, Observable_1, observeOn_1, $$observable) {
    "use strict";
    var isArrayLike = (function (x) { return x && typeof x.length === 'number'; });
    /**
     * We need this JSDoc comment for affecting ESDoc.
     * @extends {Ignored}
     * @hide true
     */
    var FromObservable = (function (_super) {
        __extends(FromObservable, _super);
        function FromObservable(ish, scheduler) {
            _super.call(this, null);
            this.ish = ish;
            this.scheduler = scheduler;
        }
        /**
         * Creates an Observable from an Array, an array-like object, a Promise, an
         * iterable object, or an Observable-like object.
         *
         * <span class="informal">Converts almost anything to an Observable.</span>
         *
         * <img src="./img/from.png" width="100%">
         *
         * Convert various other objects and data types into Observables. `from`
         * converts a Promise or an array-like or an
         * [iterable](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#iterable)
         * object into an Observable that emits the items in that promise or array or
         * iterable. A String, in this context, is treated as an array of characters.
         * Observable-like objects (contains a function named with the ES2015 Symbol
         * for Observable) can also be converted through this operator.
         *
         * @example <caption>Converts an array to an Observable</caption>
         * var array = [10, 20, 30];
         * var result = Rx.Observable.from(array);
         * result.subscribe(x => console.log(x));
         *
         * @example <caption>Convert an infinite iterable (from a generator) to an Observable</caption>
         * function* generateDoubles(seed) {
         *   var i = seed;
         *   while (true) {
         *     yield i;
         *     i = 2 * i; // double it
         *   }
         * }
         *
         * var iterator = generateDoubles(3);
         * var result = Rx.Observable.from(iterator).take(10);
         * result.subscribe(x => console.log(x));
         *
         * @see {@link create}
         * @see {@link fromEvent}
         * @see {@link fromEventPattern}
         * @see {@link fromPromise}
         *
         * @param {ObservableInput<T>} ish A subscribable object, a Promise, an
         * Observable-like, an Array, an iterable or an array-like object to be
         * converted.
         * @param {function(x: any, i: number): T} [mapFn] A "map" function to call
         * when converting array-like objects, where `x` is a value from the
         * array-like and `i` is the index of that value in the sequence.
         * @param {any} [thisArg] The context object to use when calling the `mapFn`,
         * if provided.
         * @param {Scheduler} [scheduler] The scheduler on which to schedule the
         * emissions of values.
         * @return {Observable<T>} The Observable whose values are originally from the
         * input object that was converted.
         * @static true
         * @name from
         * @owner Observable
         */
        FromObservable.create = function (ish, mapFnOrScheduler, thisArg, lastScheduler) {
            var scheduler = null;
            var mapFn = null;
            if (isFunction_1.isFunction(mapFnOrScheduler)) {
                scheduler = lastScheduler || null;
                mapFn = mapFnOrScheduler;
            }
            else if (isScheduler_1.isScheduler(scheduler)) {
                scheduler = mapFnOrScheduler;
            }
            if (ish != null) {
                if (typeof ish[$$observable] === 'function') {
                    if (ish instanceof Observable_1.Observable && !scheduler) {
                        return ish;
                    }
                    return new FromObservable(ish, scheduler);
                }
                else if (isArray_1.isArray(ish)) {
                    return new ArrayObservable_1.ArrayObservable(ish, scheduler);
                }
                else if (isPromise_1.isPromise(ish)) {
                    return new PromiseObservable_1.PromiseObservable(ish, scheduler);
                }
                else if (typeof ish[iterator_1.$$iterator] === 'function' || typeof ish === 'string') {
                    return new IteratorObservable_1.IteratorObservable(ish, null, null, scheduler);
                }
                else if (isArrayLike(ish)) {
                    return new ArrayLikeObservable_1.ArrayLikeObservable(ish, mapFn, thisArg, scheduler);
                }
            }
            throw new TypeError((ish !== null && typeof ish || ish) + ' is not observable');
        };
        FromObservable.prototype._subscribe = function (subscriber) {
            var ish = this.ish;
            var scheduler = this.scheduler;
            if (scheduler == null) {
                return ish[$$observable]().subscribe(subscriber);
            }
            else {
                return ish[$$observable]().subscribe(new observeOn_1.ObserveOnSubscriber(subscriber, scheduler, 0));
            }
        };
        return FromObservable;
    }(Observable_1.Observable));
    exports.FromObservable = FromObservable;
});
//# sourceMappingURL=FromObservable.js.map