var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, OuterSubscriber_1, subscribeToResult_1) {
    "use strict";
    /**
     * Converts a higher-order Observable into a first-order Observable by dropping
     * inner Observables while the previous inner Observable has not yet completed.
     *
     * <span class="informal">Flattens an Observable-of-Observables by dropping the
     * next inner Observables while the current inner is still executing.</span>
     *
     * <img src="./img/exhaust.png" width="100%">
     *
     * `exhaust` subscribes to an Observable that emits Observables, also known as a
     * higher-order Observable. Each time it observes one of these emitted inner
     * Observables, the output Observable begins emitting the items emitted by that
     * inner Observable. So far, it behaves like {@link mergeAll}. However,
     * `exhaust` ignores every new inner Observable if the previous Observable has
     * not yet completed. Once that one completes, it will accept and flatten the
     * next inner Observable and repeat this process.
     *
     * @example <caption>Run a finite timer for each click, only if there is no currently active timer</caption>
     * var clicks = Rx.Observable.fromEvent(document, 'click');
     * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000));
     * var result = higherOrder.exhaust();
     * result.subscribe(x => console.log(x));
     *
     * @see {@link combineAll}
     * @see {@link concatAll}
     * @see {@link switch}
     * @see {@link mergeAll}
     * @see {@link exhaustMap}
     * @see {@link zipAll}
     *
     * @return {Observable} Returns an Observable that takes a source of Observables
     * and propagates the first observable exclusively until it completes before
     * subscribing to the next.
     * @method exhaust
     * @owner Observable
     */
    function exhaust() {
        return this.lift(new SwitchFirstOperator());
    }
    exports.exhaust = exhaust;
    var SwitchFirstOperator = (function () {
        function SwitchFirstOperator() {
        }
        SwitchFirstOperator.prototype.call = function (subscriber, source) {
            return source._subscribe(new SwitchFirstSubscriber(subscriber));
        };
        return SwitchFirstOperator;
    }());
    /**
     * We need this JSDoc comment for affecting ESDoc.
     * @ignore
     * @extends {Ignored}
     */
    var SwitchFirstSubscriber = (function (_super) {
        __extends(SwitchFirstSubscriber, _super);
        function SwitchFirstSubscriber(destination) {
            _super.call(this, destination);
            this.hasCompleted = false;
            this.hasSubscription = false;
        }
        SwitchFirstSubscriber.prototype._next = function (value) {
            if (!this.hasSubscription) {
                this.hasSubscription = true;
                this.add(subscribeToResult_1.subscribeToResult(this, value));
            }
        };
        SwitchFirstSubscriber.prototype._complete = function () {
            this.hasCompleted = true;
            if (!this.hasSubscription) {
                this.destination.complete();
            }
        };
        SwitchFirstSubscriber.prototype.notifyComplete = function (innerSub) {
            this.remove(innerSub);
            this.hasSubscription = false;
            if (this.hasCompleted) {
                this.destination.complete();
            }
        };
        return SwitchFirstSubscriber;
    }(OuterSubscriber_1.OuterSubscriber));
});
//# sourceMappingURL=exhaust.js.map