var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, OuterSubscriber_1, subscribeToResult_1) {
    "use strict";
    /**
     * Converts a higher-order Observable into a first-order Observable which
     * concurrently delivers all values that are emitted on the inner Observables.
     *
     * <span class="informal">Flattens an Observable-of-Observables.</span>
     *
     * <img src="./img/mergeAll.png" width="100%">
     *
     * `mergeAll` subscribes to an Observable that emits Observables, also known as
     * a higher-order Observable. Each time it observes one of these emitted inner
     * Observables, it subscribes to that and delivers all the values from the
     * inner Observable on the output Observable. The output Observable only
     * completes once all inner Observables have completed. Any error delivered by
     * a inner Observable will be immediately emitted on the output Observable.
     *
     * @example <caption>Spawn a new interval Observable for each click event, and blend their outputs as one Observable</caption>
     * var clicks = Rx.Observable.fromEvent(document, 'click');
     * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000));
     * var firstOrder = higherOrder.mergeAll();
     * firstOrder.subscribe(x => console.log(x));
     *
     * @example <caption>Count from 0 to 9 every second for each click, but only allow 2 concurrent timers</caption>
     * var clicks = Rx.Observable.fromEvent(document, 'click');
     * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000).take(10));
     * var firstOrder = higherOrder.mergeAll(2);
     * firstOrder.subscribe(x => console.log(x));
     *
     * @see {@link combineAll}
     * @see {@link concatAll}
     * @see {@link exhaust}
     * @see {@link merge}
     * @see {@link mergeMap}
     * @see {@link mergeMapTo}
     * @see {@link mergeScan}
     * @see {@link switch}
     * @see {@link zipAll}
     *
     * @param {number} [concurrent=Number.POSITIVE_INFINITY] Maximum number of inner
     * Observables being subscribed to concurrently.
     * @return {Observable} An Observable that emits values coming from all the
     * inner Observables emitted by the source Observable.
     * @method mergeAll
     * @owner Observable
     */
    function mergeAll(concurrent) {
        if (concurrent === void 0) { concurrent = Number.POSITIVE_INFINITY; }
        return this.lift(new MergeAllOperator(concurrent));
    }
    exports.mergeAll = mergeAll;
    var MergeAllOperator = (function () {
        function MergeAllOperator(concurrent) {
            this.concurrent = concurrent;
        }
        MergeAllOperator.prototype.call = function (observer, source) {
            return source._subscribe(new MergeAllSubscriber(observer, this.concurrent));
        };
        return MergeAllOperator;
    }());
    exports.MergeAllOperator = MergeAllOperator;
    /**
     * We need this JSDoc comment for affecting ESDoc.
     * @ignore
     * @extends {Ignored}
     */
    var MergeAllSubscriber = (function (_super) {
        __extends(MergeAllSubscriber, _super);
        function MergeAllSubscriber(destination, concurrent) {
            _super.call(this, destination);
            this.concurrent = concurrent;
            this.hasCompleted = false;
            this.buffer = [];
            this.active = 0;
        }
        MergeAllSubscriber.prototype._next = function (observable) {
            if (this.active < this.concurrent) {
                this.active++;
                this.add(subscribeToResult_1.subscribeToResult(this, observable));
            }
            else {
                this.buffer.push(observable);
            }
        };
        MergeAllSubscriber.prototype._complete = function () {
            this.hasCompleted = true;
            if (this.active === 0 && this.buffer.length === 0) {
                this.destination.complete();
            }
        };
        MergeAllSubscriber.prototype.notifyComplete = function (innerSub) {
            var buffer = this.buffer;
            this.remove(innerSub);
            this.active--;
            if (buffer.length > 0) {
                this._next(buffer.shift());
            }
            else if (this.active === 0 && this.hasCompleted) {
                this.destination.complete();
            }
        };
        return MergeAllSubscriber;
    }(OuterSubscriber_1.OuterSubscriber));
    exports.MergeAllSubscriber = MergeAllSubscriber;
});
//# sourceMappingURL=mergeAll.js.map