define(["require", "exports", '../observable/MulticastObservable', '../observable/ConnectableObservable'], function (require, exports, MulticastObservable_1, ConnectableObservable_1) {
    "use strict";
    /**
     * Returns an Observable that emits the results of invoking a specified selector on items
     * emitted by a ConnectableObservable that shares a single subscription to the underlying stream.
     *
     * <img src="./img/multicast.png" width="100%">
     *
     * @param {Function|Subject} Factory function to create an intermediate subject through
     * which the source sequence's elements will be multicast to the selector function
     * or Subject to push source elements into.
     * @param {Function} Optional selector function that can use the multicasted source stream
     * as many times as needed, without causing multiple subscriptions to the source stream.
     * Subscribers to the given source will receive all notifications of the source from the
     * time of the subscription forward.
     * @return {Observable} an Observable that emits the results of invoking the selector
     * on the items emitted by a `ConnectableObservable` that shares a single subscription to
     * the underlying stream.
     * @method multicast
     * @owner Observable
     */
    function multicast(subjectOrSubjectFactory, selector) {
        var subjectFactory;
        if (typeof subjectOrSubjectFactory === 'function') {
            subjectFactory = subjectOrSubjectFactory;
        }
        else {
            subjectFactory = function subjectFactory() {
                return subjectOrSubjectFactory;
            };
        }
        var connectable = new ConnectableObservable_1.ConnectableObservable(this, subjectFactory);
        return selector ? new MulticastObservable_1.MulticastObservable(this, connectable, selector) : connectable;
    }
    exports.multicast = multicast;
});
//# sourceMappingURL=multicast.js.map