var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, OuterSubscriber_1, subscribeToResult_1) {
    "use strict";
    /**
     * Emits the most recently emitted value from the source Observable whenever
     * another Observable, the `notifier`, emits.
     *
     * <span class="informal">It's like {@link sampleTime}, but samples whenever
     * the `notifier` Observable emits something.</span>
     *
     * <img src="./img/sample.png" width="100%">
     *
     * Whenever the `notifier` Observable emits a value or completes, `sample`
     * looks at the source Observable and emits whichever value it has most recently
     * emitted since the previous sampling, unless the source has not emitted
     * anything since the previous sampling. The `notifier` is subscribed to as soon
     * as the output Observable is subscribed.
     *
     * @example <caption>On every click, sample the most recent "seconds" timer</caption>
     * var seconds = Rx.Observable.interval(1000);
     * var clicks = Rx.Observable.fromEvent(document, 'click');
     * var result = seconds.sample(clicks);
     * result.subscribe(x => console.log(x));
     *
     * @see {@link audit}
     * @see {@link debounce}
     * @see {@link sampleTime}
     * @see {@link throttle}
     *
     * @param {Observable<any>} notifier The Observable to use for sampling the
     * source Observable.
     * @return {Observable<T>} An Observable that emits the results of sampling the
     * values emitted by the source Observable whenever the notifier Observable
     * emits value or completes.
     * @method sample
     * @owner Observable
     */
    function sample(notifier) {
        return this.lift(new SampleOperator(notifier));
    }
    exports.sample = sample;
    var SampleOperator = (function () {
        function SampleOperator(notifier) {
            this.notifier = notifier;
        }
        SampleOperator.prototype.call = function (subscriber, source) {
            return source._subscribe(new SampleSubscriber(subscriber, this.notifier));
        };
        return SampleOperator;
    }());
    /**
     * We need this JSDoc comment for affecting ESDoc.
     * @ignore
     * @extends {Ignored}
     */
    var SampleSubscriber = (function (_super) {
        __extends(SampleSubscriber, _super);
        function SampleSubscriber(destination, notifier) {
            _super.call(this, destination);
            this.hasValue = false;
            this.add(subscribeToResult_1.subscribeToResult(this, notifier));
        }
        SampleSubscriber.prototype._next = function (value) {
            this.value = value;
            this.hasValue = true;
        };
        SampleSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
            this.emitValue();
        };
        SampleSubscriber.prototype.notifyComplete = function () {
            this.emitValue();
        };
        SampleSubscriber.prototype.emitValue = function () {
            if (this.hasValue) {
                this.hasValue = false;
                this.destination.next(this.value);
            }
        };
        return SampleSubscriber;
    }(OuterSubscriber_1.OuterSubscriber));
});
//# sourceMappingURL=sample.js.map