var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
define(["require", "exports", '../OuterSubscriber', '../util/subscribeToResult'], function (require, exports, OuterSubscriber_1, subscribeToResult_1) {
    "use strict";
    /**
     * Converts a higher-order Observable into a first-order Observable by
     * subscribing to only the most recently emitted of those inner Observables.
     *
     * <span class="informal">Flattens an Observable-of-Observables by dropping the
     * previous inner Observable once a new one appears.</span>
     *
     * <img src="./img/switch.png" width="100%">
     *
     * `switch` subscribes to an Observable that emits Observables, also known as a
     * higher-order Observable. Each time it observes one of these emitted inner
     * Observables, the output Observable subscribes to the inner Observable and
     * begins emitting the items emitted by that. So far, it behaves
     * like {@link mergeAll}. However, when a new inner Observable is emitted,
     * `switch` unsubscribes from the earlier-emitted inner Observable and
     * subscribes to the new inner Observable and begins emitting items from it. It
     * continues to behave like this for subsequent inner Observables.
     *
     * @example <caption>Rerun an interval Observable on every click event</caption>
     * var clicks = Rx.Observable.fromEvent(document, 'click');
     * // Each click event is mapped to an Observable that ticks every second
     * var higherOrder = clicks.map((ev) => Rx.Observable.interval(1000));
     * var switched = higherOrder.switch();
     * // The outcome is that `switched` is essentially a timer that restarts
     * // on every click. The interval Observables from older clicks do not merge
     * // with the current interval Observable.
     * switched.subscribe(x => console.log(x));
     *
     * @see {@link combineAll}
     * @see {@link concatAll}
     * @see {@link exhaust}
     * @see {@link mergeAll}
     * @see {@link switchMap}
     * @see {@link switchMapTo}
     * @see {@link zipAll}
     *
     * @return {Observable<T>} An Observable that emits the items emitted by the
     * Observable most recently emitted by the source Observable.
     * @method switch
     * @name switch
     * @owner Observable
     */
    function _switch() {
        return this.lift(new SwitchOperator());
    }
    exports._switch = _switch;
    var SwitchOperator = (function () {
        function SwitchOperator() {
        }
        SwitchOperator.prototype.call = function (subscriber, source) {
            return source._subscribe(new SwitchSubscriber(subscriber));
        };
        return SwitchOperator;
    }());
    /**
     * We need this JSDoc comment for affecting ESDoc.
     * @ignore
     * @extends {Ignored}
     */
    var SwitchSubscriber = (function (_super) {
        __extends(SwitchSubscriber, _super);
        function SwitchSubscriber(destination) {
            _super.call(this, destination);
            this.active = 0;
            this.hasCompleted = false;
        }
        SwitchSubscriber.prototype._next = function (value) {
            this.unsubscribeInner();
            this.active++;
            this.add(this.innerSubscription = subscribeToResult_1.subscribeToResult(this, value));
        };
        SwitchSubscriber.prototype._complete = function () {
            this.hasCompleted = true;
            if (this.active === 0) {
                this.destination.complete();
            }
        };
        SwitchSubscriber.prototype.unsubscribeInner = function () {
            this.active = this.active > 0 ? this.active - 1 : 0;
            var innerSubscription = this.innerSubscription;
            if (innerSubscription) {
                innerSubscription.unsubscribe();
                this.remove(innerSubscription);
            }
        };
        SwitchSubscriber.prototype.notifyNext = function (outerValue, innerValue, outerIndex, innerIndex, innerSub) {
            this.destination.next(innerValue);
        };
        SwitchSubscriber.prototype.notifyError = function (err) {
            this.destination.error(err);
        };
        SwitchSubscriber.prototype.notifyComplete = function () {
            this.unsubscribeInner();
            if (this.hasCompleted && this.active === 0) {
                this.destination.complete();
            }
        };
        return SwitchSubscriber;
    }(OuterSubscriber_1.OuterSubscriber));
});
//# sourceMappingURL=switch.js.map