import { Subject } from './Subject';
import { Subscription } from './Subscription';
/**
 * @class AsyncSubject<T>
 */
export class AsyncSubject extends Subject {
    constructor(...args) {
        super(...args);
        this.value = null;
        this.hasNext = false;
        this.hasCompleted = false;
    }
    _subscribe(subscriber) {
        if (this.hasCompleted && this.hasNext) {
            subscriber.next(this.value);
            subscriber.complete();
            return Subscription.EMPTY;
        }
        else if (this.hasError) {
            subscriber.error(this.thrownError);
            return Subscription.EMPTY;
        }
        return super._subscribe(subscriber);
    }
    next(value) {
        this.value = value;
        this.hasNext = true;
    }
    complete() {
        this.hasCompleted = true;
        if (this.hasNext) {
            super.next(this.value);
        }
        super.complete();
    }
}
//# sourceMappingURL=AsyncSubject.js.map