import { Observable } from '../Observable';
export class MulticastObservable extends Observable {
    constructor(source, connectable, selector) {
        super();
        this.source = source;
        this.connectable = connectable;
        this.selector = selector;
    }
    _subscribe(subscriber) {
        const { selector, connectable } = this;
        const subscription = selector(connectable).subscribe(subscriber);
        subscription.add(connectable.connect());
        return subscription;
    }
}
//# sourceMappingURL=MulticastObservable.js.map