import { ArrayObservable } from '../observable/ArrayObservable';
import { ScalarObservable } from '../observable/ScalarObservable';
import { EmptyObservable } from '../observable/EmptyObservable';
import { concatStatic } from './concat';
import { isScheduler } from '../util/isScheduler';
/**
 * Returns an Observable that emits the items in a specified Iterable before it begins to emit items emitted by the
 * source Observable.
 *
 * <img src="./img/startWith.png" width="100%">
 *
 * @param {Values} an Iterable that contains the items you want the modified Observable to emit first.
 * @return {Observable} an Observable that emits the items in the specified Iterable and then emits the items
 * emitted by the source Observable.
 * @method startWith
 * @owner Observable
 */
export function startWith(...array) {
    let scheduler = array[array.length - 1];
    if (isScheduler(scheduler)) {
        array.pop();
    }
    else {
        scheduler = null;
    }
    const len = array.length;
    if (len === 1) {
        return concatStatic(new ScalarObservable(array[0], scheduler), this);
    }
    else if (len > 1) {
        return concatStatic(new ArrayObservable(array, scheduler), this);
    }
    else {
        return concatStatic(new EmptyObservable(scheduler), this);
    }
}
//# sourceMappingURL=startWith.js.map