/**
 * An error thrown when one or more errors have occurred during the
 * `unsubscribe` of a {@link Subscription}.
 */
export class UnsubscriptionError extends Error {
    constructor(errors) {
        super();
        this.errors = errors;
        this.name = 'UnsubscriptionError';
        this.message = errors ? `${errors.length} errors occurred during unsubscription:
${errors.map((err, i) => `${i + 1}) ${err.toString()}`).join('\n')}` : '';
    }
}
//# sourceMappingURL=UnsubscriptionError.js.map