"use strict";
var chai_1 = require('chai');
var Rx = require('../dist/cjs/Rx');
var Observable = Rx.Observable;
var Subscription = Rx.Subscription;
/** @test {Subscription} */
describe('Subscription', function () {
    it('should not leak', function (done) {
        var tearDowns = [];
        var source1 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(1);
            };
        });
        var source2 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(2);
                throw new Error('oops, I am a bad unsubscribe!');
            };
        });
        var source3 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(3);
            };
        });
        var subscription = Observable.merge(source1, source2, source3).subscribe();
        setTimeout(function () {
            chai_1.expect(function () {
                subscription.unsubscribe();
            }).to.throw(Rx.UnsubscriptionError);
            chai_1.expect(tearDowns).to.deep.equal([1, 2, 3]);
            done();
        });
    });
    it('should not leak when adding a bad custom subscription to a subscription', function (done) {
        var tearDowns = [];
        var sub = new Subscription();
        var source1 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(1);
            };
        });
        var source2 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(2);
                sub.add(({
                    unsubscribe: function () {
                        chai_1.expect(sub.isUnsubscribed).to.be.true;
                        throw new Error('Who is your daddy, and what does he do?');
                    }
                }));
            };
        });
        var source3 = Observable.create(function (observer) {
            return function () {
                tearDowns.push(3);
            };
        });
        sub.add(Observable.merge(source1, source2, source3).subscribe());
        setTimeout(function () {
            chai_1.expect(function () {
                sub.unsubscribe();
            }).to.throw(Rx.UnsubscriptionError);
            chai_1.expect(tearDowns).to.deep.equal([1, 2, 3]);
            done();
        });
    });
});
//# sourceMappingURL=Subscription-spec.js.map