"use strict";
var chai_1 = require('chai');
var Rx = require('../../dist/cjs/Rx');
var asap = Rx.Scheduler.asap;
/** @test {Scheduler} */
describe('Scheduler.asap', function () {
    it('should exist', function () {
        chai_1.expect(asap).exist;
    });
    it('should schedule an action to happen later', function (done) {
        var actionHappened = false;
        asap.schedule(function () {
            actionHappened = true;
            done();
        });
        if (actionHappened) {
            done(new Error('Scheduled action happened synchronously'));
        }
    });
    it('should execute the rest of the scheduled actions if the first action is canceled', function (done) {
        var actionHappened = false;
        var firstSubscription = null;
        var secondSubscription = null;
        firstSubscription = asap.schedule(function () {
            actionHappened = true;
            if (secondSubscription) {
                secondSubscription.unsubscribe();
            }
            done(new Error('The first action should not have executed.'));
        });
        secondSubscription = asap.schedule(function () {
            if (!actionHappened) {
                done();
            }
        });
        if (actionHappened) {
            done(new Error('Scheduled action happened synchronously'));
        }
        else {
            firstSubscription.unsubscribe();
        }
    });
});
//# sourceMappingURL=AsapScheduler-spec.js.map