'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactAddonsCssTransitionGroup = require('react-addons-css-transition-group');

var _reactAddonsCssTransitionGroup2 = _interopRequireDefault(_reactAddonsCssTransitionGroup);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var FirstChild = function FirstChild(_ref) {
  var children = _ref.children;
  return _react2.default.Children.toArray(children)[0] || null;
};

var propTypes = {
  children: _react.PropTypes.node,
  className: _react.PropTypes.string,
  cssModule: _react.PropTypes.object,
  color: _react.PropTypes.string,
  isOpen: _react.PropTypes.bool,
  toggle: _react.PropTypes.func,
  tag: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.string]),
  transitionAppearTimeout: _react.PropTypes.number,
  transitionEnterTimeout: _react.PropTypes.number,
  transitionLeaveTimeout: _react.PropTypes.number
};

var defaultProps = {
  color: 'success',
  isOpen: true,
  tag: 'div',
  transitionAppearTimeout: 150,
  transitionEnterTimeout: 150,
  transitionLeaveTimeout: 150
};

var Alert = function Alert(props) {
  var className = props.className,
      cssModule = props.cssModule,
      Tag = props.tag,
      color = props.color,
      isOpen = props.isOpen,
      toggle = props.toggle,
      children = props.children,
      transitionAppearTimeout = props.transitionAppearTimeout,
      transitionEnterTimeout = props.transitionEnterTimeout,
      transitionLeaveTimeout = props.transitionLeaveTimeout,
      attributes = _objectWithoutProperties(props, ['className', 'cssModule', 'tag', 'color', 'isOpen', 'toggle', 'children', 'transitionAppearTimeout', 'transitionEnterTimeout', 'transitionLeaveTimeout']);

  var classes = (0, _utils.mapToCssModules)((0, _classnames2.default)(className, 'alert', 'alert-' + color, { 'alert-dismissible': toggle }), cssModule);

  var alert = _react2.default.createElement(
    Tag,
    _extends({}, attributes, { className: classes, role: 'alert' }),
    toggle ? _react2.default.createElement(
      'button',
      { type: 'button', className: 'close', 'aria-label': 'Close', onClick: toggle },
      _react2.default.createElement(
        'span',
        { 'aria-hidden': 'true' },
        '\xD7'
      )
    ) : null,
    children
  );

  return _react2.default.createElement(
    _reactAddonsCssTransitionGroup2.default,
    {
      component: FirstChild,
      transitionName: {
        appear: 'fade',
        appearActive: 'show',
        enter: 'fade',
        enterActive: 'show',
        leave: 'fade',
        leaveActive: 'out'
      },
      transitionAppear: transitionAppearTimeout > 0,
      transitionAppearTimeout: transitionAppearTimeout,
      transitionEnter: transitionEnterTimeout > 0,
      transitionEnterTimeout: transitionEnterTimeout,
      transitionLeave: transitionLeaveTimeout > 0,
      transitionLeaveTimeout: transitionLeaveTimeout
    },
    isOpen ? alert : null
  );
};

Alert.propTypes = propTypes;
Alert.defaultProps = defaultProps;

exports.default = Alert;