'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var propTypes = {
  'aria-label': _react.PropTypes.string,
  className: _react.PropTypes.string,
  cssModule: _react.PropTypes.object,
  role: _react.PropTypes.string,
  size: _react.PropTypes.string,
  vertical: _react.PropTypes.bool
};

var defaultProps = {
  role: 'group'
};

var ButtonGroup = function ButtonGroup(props) {
  var className = props.className,
      cssModule = props.cssModule,
      size = props.size,
      vertical = props.vertical,
      attributes = _objectWithoutProperties(props, ['className', 'cssModule', 'size', 'vertical']);

  var classes = (0, _utils.mapToCssModules)((0, _classnames2.default)(className, size ? 'btn-group-' + size : false, vertical ? 'btn-group-vertical' : 'btn-group'), cssModule);

  return _react2.default.createElement('div', _extends({}, attributes, { className: classes }));
};

ButtonGroup.propTypes = propTypes;
ButtonGroup.defaultProps = defaultProps;

exports.default = ButtonGroup;