'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash.omit');

var _lodash2 = _interopRequireDefault(_lodash);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var propTypes = {
  baseClass: _react.PropTypes.string,
  baseClassIn: _react.PropTypes.string,
  tag: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.string]),
  className: _react.PropTypes.string,
  cssModule: _react.PropTypes.object,
  transitionAppearTimeout: _react.PropTypes.number,
  transitionEnterTimeout: _react.PropTypes.number,
  transitionLeaveTimeout: _react.PropTypes.number,
  transitionAppear: _react.PropTypes.bool,
  transitionEnter: _react.PropTypes.bool,
  transitionLeave: _react.PropTypes.bool,
  onLeave: _react.PropTypes.func,
  onEnter: _react.PropTypes.func
};

var defaultProps = {
  tag: 'div',
  baseClass: 'fade',
  baseClassIn: 'show',
  transitionAppearTimeout: 0,
  transitionEnterTimeout: 0,
  transitionLeaveTimeout: 0,
  transitionAppear: true,
  transitionEnter: true,
  transitionLeave: true
};

var Fade = function (_React$Component) {
  _inherits(Fade, _React$Component);

  function Fade(props) {
    _classCallCheck(this, Fade);

    var _this = _possibleConstructorReturn(this, (Fade.__proto__ || Object.getPrototypeOf(Fade)).call(this, props));

    _this.state = {
      mounted: !props.transitionAppear
    };

    _this.onLeave = _this.onLeave.bind(_this);
    _this.onEnter = _this.onEnter.bind(_this);
    _this.timers = [];
    return _this;
  }

  _createClass(Fade, [{
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      this.timers.forEach(function (timer) {
        return clearTimeout(timer);
      });
    }
  }, {
    key: 'onEnter',
    value: function onEnter(cb) {
      var _this2 = this;

      return function () {
        cb();
        if (_this2.props.onEnter) {
          _this2.props.onEnter();
        }
      };
    }
  }, {
    key: 'onLeave',
    value: function onLeave(cb) {
      var _this3 = this;

      return function () {
        cb();
        if (_this3.props.onLeave) {
          _this3.props.onLeave();
        }
      };
    }
  }, {
    key: 'componentWillAppear',
    value: function componentWillAppear(cb) {
      if (!this.props.transitionAppear) {
        this.onEnter(cb)();
      }

      this.timers.push(setTimeout(this.onEnter(cb), this.props.transitionAppearTimeout));
    }
  }, {
    key: 'componentDidAppear',
    value: function componentDidAppear() {
      this.setState({
        mounted: true
      });
    }
  }, {
    key: 'componentWillEnter',
    value: function componentWillEnter(cb) {
      if (!this.props.transitionEnter) {
        this.onEnter(cb)();
      }

      this.timers.push(setTimeout(this.onEnter(cb), this.props.transitionEnterTimeout));
    }
  }, {
    key: 'componentDidEnter',
    value: function componentDidEnter() {
      this.setState({
        mounted: true
      });
    }
  }, {
    key: 'componentWillLeave',
    value: function componentWillLeave(cb) {
      this.setState({
        mounted: false
      });

      if (!this.props.transitionLeave) {
        this.onLeave(cb)();
      }

      this.timers.push(setTimeout(this.onLeave(cb), this.props.transitionLeaveTimeout));
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          baseClass = _props.baseClass,
          baseClassIn = _props.baseClassIn,
          className = _props.className,
          cssModule = _props.cssModule,
          Tag = _props.tag;

      var attributes = (0, _lodash2.default)(this.props, Object.keys(propTypes));

      var classes = (0, _utils.mapToCssModules)((0, _classnames2.default)(className, baseClass, this.state.mounted ? baseClassIn : false), cssModule);

      return _react2.default.createElement(Tag, _extends({}, attributes, { className: classes }));
    }
  }]);

  return Fade;
}(_react2.default.Component);

Fade.propTypes = propTypes;
Fade.defaultProps = defaultProps;

exports.default = Fade;