'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

var _Button = require('./Button');

var _Button2 = _interopRequireDefault(_Button);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var propTypes = {
  tag: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.string]),
  children: _react.PropTypes.node,
  groupClassName: _react.PropTypes.string,
  groupAttributes: _react.PropTypes.object,
  className: _react.PropTypes.string,
  cssModule: _react.PropTypes.object
};

var defaultProps = {
  tag: 'div'
};

var InputGroupButton = function InputGroupButton(props) {
  var className = props.className,
      cssModule = props.cssModule,
      Tag = props.tag,
      children = props.children,
      groupClassName = props.groupClassName,
      groupAttributes = props.groupAttributes,
      attributes = _objectWithoutProperties(props, ['className', 'cssModule', 'tag', 'children', 'groupClassName', 'groupAttributes']);

  if (typeof children === 'string') {
    var groupClasses = (0, _utils.mapToCssModules)((0, _classnames2.default)(groupClassName, 'input-group-btn'), cssModule);

    return _react2.default.createElement(
      Tag,
      _extends({}, groupAttributes, { className: groupClasses }),
      _react2.default.createElement(_Button2.default, _extends({}, attributes, { className: className, children: children }))
    );
  }

  var classes = (0, _utils.mapToCssModules)((0, _classnames2.default)(className, 'input-group-btn'), cssModule);

  return _react2.default.createElement(Tag, _extends({}, attributes, { className: classes, children: children }));
};

InputGroupButton.propTypes = propTypes;
InputGroupButton.defaultProps = defaultProps;

exports.default = InputGroupButton;