'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var propTypes = {
  className: _react.PropTypes.string,
  cssModule: _react.PropTypes.object,
  size: _react.PropTypes.string,
  bordered: _react.PropTypes.bool,
  striped: _react.PropTypes.bool,
  inverse: _react.PropTypes.bool,
  hover: _react.PropTypes.bool,
  reflow: _react.PropTypes.bool,
  responsive: _react.PropTypes.bool,
  tag: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.string])
};

var defaultProps = {
  tag: 'table'
};

var Table = function Table(props) {
  var className = props.className,
      cssModule = props.cssModule,
      size = props.size,
      bordered = props.bordered,
      striped = props.striped,
      inverse = props.inverse,
      hover = props.hover,
      reflow = props.reflow,
      responsive = props.responsive,
      Tag = props.tag,
      attributes = _objectWithoutProperties(props, ['className', 'cssModule', 'size', 'bordered', 'striped', 'inverse', 'hover', 'reflow', 'responsive', 'tag']);

  var classes = (0, _utils.mapToCssModules)((0, _classnames2.default)(className, 'table', size ? 'table-' + size : false, bordered ? 'table-bordered' : false, striped ? 'table-striped' : false, inverse ? 'table-inverse' : false, hover ? 'table-hover' : false, reflow ? 'table-reflow' : false), cssModule);

  var table = _react2.default.createElement(Tag, _extends({}, attributes, { className: classes }));

  if (responsive) {
    return _react2.default.createElement(
      'div',
      { className: 'table-responsive' },
      table
    );
  }

  return table;
};

Table.propTypes = propTypes;
Table.defaultProps = defaultProps;

exports.default = Table;