'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Notification = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _helpers = require('../helpers');

var _notifications = require('../store/notifications');

var _constants = require('../constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Create a timer
 * @param {Number} dismissAfter
 * @param {Array} buttons
 * @param {Function} callback
 * @returns {Function|null} a Timer
 */
function createTimer(dismissAfter, buttons, callback) {
  if (dismissAfter > 0 && (!buttons || buttons && buttons.length === 0)) {
    return new _helpers.Timer(callback, dismissAfter);
  }
  return null;
}

var Notification = exports.Notification = function (_Component) {
  _inherits(Notification, _Component);

  /**
   * Constructor
   * Bind methods
   * @param {Object} props
   * @returns {void}
   */
  function Notification(props) {
    _classCallCheck(this, Notification);

    var _props$notification = props.notification,
        dismissAfter = _props$notification.dismissAfter,
        buttons = _props$notification.buttons;

    var _this = _possibleConstructorReturn(this, (Notification.__proto__ || Object.getPrototypeOf(Notification)).call(this, props));

    _this._remove = _this._remove.bind(_this);
    _this._pauseTimer = _this._pauseTimer.bind(_this);
    _this._resumeTimer = _this._resumeTimer.bind(_this);
    _this.state = {
      timer: createTimer(dismissAfter, buttons, _this._remove)
    };
    return _this;
  }

  /**
   * Run `onAdd` callback function when component is mounted
   * @returns {void}
   */

  // Properties types


  _createClass(Notification, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var onAdd = this.props.notification.onAdd;

      if (typeof onAdd === 'function') {
        onAdd();
      }
    }

    /**
     * Run `onRemove` callback function when component will unmount
     * @returns {void}
     */

  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var onRemove = this.props.notification.onRemove;

      if (typeof onRemove === 'function') {
        onRemove();
      }
    }

    /**
     * Update timer
     * @param {Object} nextProps
     * @returns {void}
     */

  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var _nextProps$notificati = nextProps.notification,
          dismissAfter = _nextProps$notificati.dismissAfter,
          buttons = _nextProps$notificati.buttons;

      this.setState({
        timer: createTimer(dismissAfter, buttons, this._remove)
      });
    }

    /**
     * Remove the notification
     * @private
     * @returns {void}
     */

  }, {
    key: '_remove',
    value: function _remove() {
      var _props = this.props,
          removeNotification = _props.removeNotification,
          id = _props.notification.id;

      removeNotification(id);
    }

    /**
     * Pauses the timer
     * @returns {void}
     * @private
     */

  }, {
    key: '_pauseTimer',
    value: function _pauseTimer() {
      var timer = this.state.timer;

      timer.pause();
    }

    /**
     * Resumes the timer
     * @returns {void}
     * @private
     */

  }, {
    key: '_resumeTimer',
    value: function _resumeTimer() {
      var timer = this.state.timer;

      timer.resume();
    }

    /**
     * Wrap content in an object ready for HTML
     * @param {String} content a text
     * @returns {Object}
     * @private
     */

  }, {
    key: '_setHTML',
    value: function _setHTML(content) {
      return {
        __html: content
      };
    }

    /**
     * Render button(s)
     * @returns {*}
     */

  }, {
    key: '_renderButtons',
    value: function _renderButtons() {
      var _props2 = this.props,
          className = _props2.className,
          buttons = _props2.notification.buttons;


      return buttons.map(function (button) {
        return _react2.default.createElement(
          'button',
          { key: button.name, className: className.button, onClick: button.onClick },
          _react2.default.createElement(
            'span',
            { className: className.buttonText },
            button.primary ? _react2.default.createElement(
              'b',
              null,
              button.name
            ) : button.name
          )
        );
      });
    }

    /**
     * Render
     * @returns {XML}
     */

  }, {
    key: 'render',
    value: function render() {
      var _props3 = this.props,
          className = _props3.className,
          _props3$notification = _props3.notification,
          title = _props3$notification.title,
          message = _props3$notification.message,
          status = _props3$notification.status,
          dismissible = _props3$notification.dismissible,
          closeButton = _props3$notification.closeButton,
          buttons = _props3$notification.buttons,
          image = _props3$notification.image,
          allowHTML = _props3$notification.allowHTML;
      var timer = this.state.timer;

      var isDismissible = dismissible && buttons.length === 0;

      if (timer) {
        this._resumeTimer();
      }

      return _react2.default.createElement(
        'div',
        { className: className.wrapper,
          onClick: isDismissible && !closeButton ? this._remove : '',
          onMouseEnter: timer ? this._pauseTimer : '',
          onMouseLeave: timer ? this._resumeTimer : '' },
        _react2.default.createElement(
          'div',
          { className: className.main + ' ' + className.status(status) + ' ' + ((isDismissible && !closeButton ? className.dismissible : '') + ' ') + ('' + className.buttons(buttons.length)) },
          image ? _react2.default.createElement(
            'div',
            { className: className.imageContainer },
            _react2.default.createElement('span', { className: className.image, style: { backgroundImage: 'url(' + image + ')' } })
          ) : _react2.default.createElement('span', { className: className.icon }),
          _react2.default.createElement(
            'div',
            { className: className.meta },
            title ? allowHTML ? _react2.default.createElement('h4', { className: className.title, dangerouslySetInnerHTML: this._setHTML(title) }) : _react2.default.createElement(
              'h4',
              { className: className.title },
              title
            ) : '',
            message ? allowHTML ? _react2.default.createElement('p', { className: className.message, dangerouslySetInnerHTML: this._setHTML(message) }) : _react2.default.createElement(
              'p',
              { className: className.message },
              message
            ) : ''
          ),
          isDismissible && closeButton ? _react2.default.createElement(
            'div',
            { className: className.closeButtonContainer },
            _react2.default.createElement('span', { className: className.closeButton, onClick: this._remove })
          ) : '',
          buttons.length ? _react2.default.createElement(
            'div',
            { className: className.buttons(), onClick: this._remove },
            this._renderButtons()
          ) : ''
        )
      );
    }
  }]);

  return Notification;
}(_react.Component);

Notification.propTypes = {
  className: _react2.default.PropTypes.shape({
    main: _react2.default.PropTypes.string.isRequired,
    wrapper: _react2.default.PropTypes.string.isRequired,
    meta: _react2.default.PropTypes.string.isRequired,
    title: _react2.default.PropTypes.string.isRequired,
    message: _react2.default.PropTypes.string.isRequired,
    imageContainer: _react2.default.PropTypes.string.isRequired,
    image: _react2.default.PropTypes.string.isRequired,
    icon: _react2.default.PropTypes.string.isRequired,
    status: _react2.default.PropTypes.func.isRequired,
    dismissible: _react2.default.PropTypes.string.isRequired,
    closeButtonContainer: _react2.default.PropTypes.string.isRequired,
    closeButton: _react2.default.PropTypes.string.isRequired,
    buttons: _react2.default.PropTypes.func.isRequired,
    button: _react2.default.PropTypes.string.isRequired,
    buttonText: _react2.default.PropTypes.string.isRequired
  }).isRequired,
  notification: _react2.default.PropTypes.shape({
    id: _react2.default.PropTypes.number.isRequired,
    title: _react2.default.PropTypes.string,
    message: _react2.default.PropTypes.string,
    image: _react2.default.PropTypes.string,
    status: _react2.default.PropTypes.string.isRequired,
    position: _react2.default.PropTypes.oneOf((0, _helpers.mapObjectValues)(_constants.POSITIONS)),
    dismissAfter: _react2.default.PropTypes.number.isRequired,
    dismissible: _react2.default.PropTypes.bool.isRequired,
    onAdd: _react2.default.PropTypes.func,
    onRemove: _react2.default.PropTypes.func,
    closeButton: _react2.default.PropTypes.bool.isRequired,
    buttons: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.shape({
      name: _react2.default.PropTypes.string.isRequired,
      onClick: _react2.default.PropTypes.func
    })).isRequired,
    allowHTML: _react2.default.PropTypes.bool.isRequired
  }).isRequired,
  removeNotification: _react2.default.PropTypes.func.isRequired
};
exports.default = (0, _reactRedux.connect)(null, { removeNotification: _notifications.removeNotification })(Notification);