'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsContainer = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ReactCSSTransitionGroup = require('react/lib/ReactCSSTransitionGroup');

var _ReactCSSTransitionGroup2 = _interopRequireDefault(_ReactCSSTransitionGroup);

var _helpers = require('../helpers');

var _Notification = require('./Notification');

var _Notification2 = _interopRequireDefault(_Notification);

var _constants = require('../constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NotificationsContainer = exports.NotificationsContainer = function (_Component) {
  _inherits(NotificationsContainer, _Component);

  /**
   * Constructor
   * Bind methods
   * @param {Object} props
   * @returns {void}
   */

  // default types
  function NotificationsContainer(props) {
    _classCallCheck(this, NotificationsContainer);

    var _this = _possibleConstructorReturn(this, (NotificationsContainer.__proto__ || Object.getPrototypeOf(NotificationsContainer)).call(this, props));

    _this._renderNotifications = _this._renderNotifications.bind(_this);
    return _this;
  }

  /**
   * Render notifications
   * @private
   * @returns {XML}
   */


  // Properties types


  _createClass(NotificationsContainer, [{
    key: '_renderNotifications',
    value: function _renderNotifications() {
      // get all notifications and default values for notifications
      var _props = this.props,
          position = _props.position,
          className = _props.theme.notification.className,
          _props$defaultValues = _props.defaultValues,
          status = _props$defaultValues.status,
          dismissible = _props$defaultValues.dismissible,
          dismissAfter = _props$defaultValues.dismissAfter,
          closeButton = _props$defaultValues.closeButton,
          allowHTML = _props$defaultValues.allowHTML;
      var notifications = this.props.notifications;

      // when notifications are displayed at the bottom,
      // we display notifications from bottom to top

      if ([_constants.POSITIONS.bottomLeft, _constants.POSITIONS.bottomRight, _constants.POSITIONS.bottomCenter, _constants.POSITIONS.bottom].indexOf(position) >= 0) {
        notifications = notifications.reverse();
      }

      return notifications.map(function (notification) {
        // Define default values for notification if it's needed
        if (!notification.status) {
          notification.status = status;
        }
        if (typeof notification.dismissible !== 'boolean') {
          notification.dismissible = dismissible;
        }
        if (typeof notification.dismissAfter !== 'number') {
          notification.dismissAfter = dismissAfter;
        }
        if (typeof notification.closeButton !== 'boolean') {
          notification.closeButton = closeButton;
        }
        if (typeof notification.allowHTML !== 'boolean') {
          notification.allowHTML = allowHTML;
        }
        return _react2.default.createElement(_Notification2.default, { key: notification.id, notification: notification, className: className });
      });
    }

    /**
     * Render
     * @returns {XML}
     */

  }, {
    key: 'render',
    value: function render() {
      var _props$theme$notifica = this.props.theme.notificationsContainer,
          className = _props$theme$notifica.className,
          _props$theme$notifica2 = _props$theme$notifica.transition,
          name = _props$theme$notifica2.name,
          enterTimeout = _props$theme$notifica2.enterTimeout,
          leaveTimeout = _props$theme$notifica2.leaveTimeout;
      var position = this.props.position;


      return _react2.default.createElement(
        'div',
        { className: className.main + ' ' + className.position(position) },
        _react2.default.createElement(
          _ReactCSSTransitionGroup2.default,
          { transitionName: name, transitionEnterTimeout: enterTimeout,
            transitionLeaveTimeout: leaveTimeout },
          this._renderNotifications()
        )
      );
    }
  }]);

  return NotificationsContainer;
}(_react.Component);

NotificationsContainer.defaultProps = {
  notifications: []
};
NotificationsContainer.propTypes = {
  notifications: _react2.default.PropTypes.array.isRequired,
  position: _react2.default.PropTypes.string.isRequired,
  defaultValues: _react2.default.PropTypes.shape({
    status: _react2.default.PropTypes.string.isRequired,
    position: _react2.default.PropTypes.oneOf((0, _helpers.mapObjectValues)(_constants.POSITIONS)),
    dismissible: _react2.default.PropTypes.bool.isRequired,
    dismissAfter: _react2.default.PropTypes.number.isRequired,
    closeButton: _react2.default.PropTypes.bool.isRequired,
    allowHTML: _react2.default.PropTypes.bool.isRequired
  }).isRequired,
  theme: _react2.default.PropTypes.shape({
    notificationsContainer: _react2.default.PropTypes.shape({
      className: _react2.default.PropTypes.shape({
        main: _react2.default.PropTypes.string.isRequired,
        position: _react2.default.PropTypes.func.isRequired
      }).isRequired,
      transition: _react2.default.PropTypes.shape({
        name: _react2.default.PropTypes.object.isRequired,
        enterTimeout: _react2.default.PropTypes.number.isRequired,
        leaveTimeout: _react2.default.PropTypes.number.isRequired
      }).isRequired
    }).isRequired,
    notification: _react2.default.PropTypes.shape({
      className: _react2.default.PropTypes.object.isRequired
    }).isRequired
  }).isRequired
};
exports.default = NotificationsContainer;