'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsSystem = exports.defaultValues = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _helpers = require('../helpers');

var _NotificationsContainer = require('./NotificationsContainer');

var _NotificationsContainer2 = _interopRequireDefault(_NotificationsContainer);

var _constants = require('../constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// default value for notifications
var defaultValues = exports.defaultValues = {
  status: _constants.STATUS.default,
  position: _constants.POSITIONS.topRight,
  dismissible: true,
  dismissAfter: 5000,
  allowHTML: false,
  closeButton: false
};

var NotificationsSystem = exports.NotificationsSystem = function (_Component) {
  _inherits(NotificationsSystem, _Component);

  // default properties
  function NotificationsSystem(props) {
    _classCallCheck(this, NotificationsSystem);

    var _this = _possibleConstructorReturn(this, (NotificationsSystem.__proto__ || Object.getPrototypeOf(NotificationsSystem)).call(this, props));

    _this._updateWindowWidth = _this._updateWindowWidth.bind(_this);
    _this._renderNotificationsContainers = _this._renderNotificationsContainers.bind(_this);
    _this.state = {
      windowWidth: window.innerWidth
    };
    return _this;
  }

  /**
   * Update window width
   * @returns {void}
   * @private
   */


  // properties types


  _createClass(NotificationsSystem, [{
    key: '_updateWindowWidth',
    value: function _updateWindowWidth() {
      this.setState({ windowWidth: window.innerWidth });
    }

    /**
     * Add resize listener to update window width when the window is resized
     * @returns {void}
     */

  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      window.addEventListener('resize', this._updateWindowWidth);
    }

    /**
     * Remove resize listener
     * @returns {void}
     */

  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this._updateWindowWidth);
    }

    /**
     * Render notifications containers
     * @returns {XML}
     * @private
     */

  }, {
    key: '_renderNotificationsContainers',
    value: function _renderNotificationsContainers() {
      var _props = this.props,
          notifications = _props.notifications,
          position = _props.defaultValues.position,
          theme = _props.theme;
      var windowWidth = this.state.windowWidth;
      // render all notifications in the same container at the top for small screens

      if (windowWidth < theme.smallScreenMin) {
        return _react2.default.createElement(_NotificationsContainer2.default, { key: 't', position: 't', defaultValues: defaultValues,
          theme: theme, notifications: notifications });
      }
      var positions = (0, _helpers.mapObjectValues)(_constants.POSITIONS);
      // extract the default position of all positions
      positions.splice(positions.indexOf(position), 1);
      var notifs = notifications.filter(function (notif) {
        return !notif.position || notif.position === position;
      });
      // init array with all notifications with default position
      var JSX = [_react2.default.createElement(_NotificationsContainer2.default, { key: position, position: position, defaultValues: defaultValues,
        theme: theme, notifications: notifs })];
      // fill array with others containers
      JSX = JSX.concat(positions.map(function (position) {
        var notifs = notifications.filter(function (notif) {
          return position === notif.position;
        });
        return _react2.default.createElement(_NotificationsContainer2.default, { key: position, position: position, defaultValues: defaultValues,
          theme: theme, notifications: notifs });
      }));
      return JSX;
    }

    /**
     * Render
     * @returns {XML}
     */

  }, {
    key: 'render',
    value: function render() {
      var className = this.props.theme.notificationsSystem.className;

      return _react2.default.createElement(
        'div',
        { className: className },
        this._renderNotificationsContainers()
      );
    }
  }]);

  return NotificationsSystem;
}(_react.Component);

/**
 * Map state to props
 * @param {Object} state
 * @returns {{notifications: {Array}}}
 */


NotificationsSystem.defaultProps = {
  notifications: [],
  defaultValues: defaultValues
};
NotificationsSystem.propTypes = {
  notifications: _react2.default.PropTypes.array.isRequired,
  defaultValues: _react2.default.PropTypes.object.isRequired,
  theme: _react2.default.PropTypes.shape({
    smallScreenMin: _react2.default.PropTypes.number.isRequired,
    notificationsSystem: _react2.default.PropTypes.shape({
      className: _react2.default.PropTypes.string
    })
  }).isRequired
};
function mapStateToProps(state) {
  return {
    notifications: state.notifications
  };
}

exports.default = (0, _reactRedux.connect)(mapStateToProps)(NotificationsSystem);