'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _margins = require('./util/margins');

var _margins2 = _interopRequireDefault(_margins);

var _padding = require('./util/padding');

var _padding2 = _interopRequireDefault(_padding);

var _radii = require('./util/radii');

var _radii2 = _interopRequireDefault(_radii);

var _colorStyle = require('./util/color-style');

var _colorStyle2 = _interopRequireDefault(_colorStyle);

var _config = require('./config');

var _config2 = _interopRequireDefault(_config);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

/**
 * The Base component is internally used by all other Rebass components
 * and provides an API to apply padding, margin, color, background-color,
 * border-radius and other styles to any component.
 * All props for the Base component are available to other Rebass components to help with contextual styling.
 * It is not intended for use directly, but it can be used to create other custom components.
 */

var Base = function Base(_ref, _ref2) {
  var tagName = _ref.tagName;
  var baseStyle = _ref.baseStyle;
  var style = _ref.style;

  var props = _objectWithoutProperties(_ref, ['tagName', 'baseStyle', 'style']);

  var rebass = _ref2.rebass;

  var _config$rebass = _extends({}, _config2.default, rebass);

  var scale = _config$rebass.scale;
  var colors = _config$rebass.colors;
  var borderRadius = _config$rebass.borderRadius;

  var name = props.className;
  var keys = name ? name.split(' ') : [];
  var contextStyle = keys.reduce(function (a, key) {
    return (0, _objectAssign2.default)(a, rebass ? rebass[key] : {});
  }, {});

  var Component = tagName || 'div';

  var sx = (0, _objectAssign2.default)({ boxSizing: 'border-box' }, baseStyle, contextStyle, (0, _margins2.default)(props, scale), (0, _padding2.default)(props, scale), (0, _colorStyle2.default)(props, colors, rebass), (0, _radii2.default)(props, borderRadius), style);

  return _react2.default.createElement(Component, _extends({}, props, { style: sx }));
};

Base.propTypes = {
  /** HTML element string or React component to render */
  tagName: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.string, _react2.default.PropTypes.func, _react2.default.PropTypes.element]),
  /** Used to pull styles from the rebass context object */
  className: _react2.default.PropTypes.string,
  /** Base component styles */
  baseStyle: _react2.default.PropTypes.object,
  /** Styles from component instance - overrides base and context styles */
  style: _react2.default.PropTypes.object,

  /** Applies margin with the margin utility based on the spacing scale */
  m: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin top based on the spacing scale */
  mt: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin right based on the spacing scale */
  mr: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin bottom based on the spacing scale */
  mb: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin left based on the spacing scale */
  ml: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin left and right based on the spacing scale */
  mx: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies margin top and bottom based on the spacing scale */
  my: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),

  /** Applies padding with the padding utility based on the spacing scale */
  p: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding top based on the spacing scale */
  pt: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding right based on the spacing scale */
  pr: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding bottom based on the spacing scale */
  pb: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding left based on the spacing scale */
  pl: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding left and right based on the spacing scale */
  px: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),
  /** Applies padding top and bottom based on the spacing scale */
  py: _react2.default.PropTypes.oneOf([0, 1, 2, 3, 4]),

  /** Text color - can either be a key from the config colors object or any color value */
  color: _react2.default.PropTypes.string,
  /** Background color - can either be a key from the config colors object or any color value */
  backgroundColor: _react2.default.PropTypes.string,
  /** Sets color from config */
  theme: _react2.default.PropTypes.oneOf(['primary', 'secondary', 'default', 'info', 'success', 'warning', 'error']),
  /** Inverts colors from theme */
  inverted: _react2.default.PropTypes.bool,
  /** Controls border radius */
  rounded: _react2.default.PropTypes.oneOfType([_react2.default.PropTypes.bool, _react2.default.PropTypes.oneOf(['top', 'right', 'bottom', 'left'])]),
  /** Sets border radius 99999 */
  circle: _react2.default.PropTypes.bool,
  /** Sets border radius 99999 */
  pill: _react2.default.PropTypes.bool
};

Base.contextTypes = {
  rebass: _react2.default.PropTypes.object
};

exports.default = Base;